% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_zip.R
\name{window_zip_statistic}
\alias{window_zip_statistic}
\title{Calculate the ZIP statistic for a single space-time window.}
\usage{
window_zip_statistic(p, mu, y, ...)
}
\arguments{
\item{p}{A numeric vector of the given/estimated excess zero probabilities 
corresponding to each count.}

\item{mu}{A numeric vector of the given/estimated Poisson expected value
parameters corresponding to each count. Of same length as \code{p}.}

\item{y}{An integer vector of the observed counts, of same length as 
\code{p}.}

\item{...}{Named parameters passed to \code{\link{zip_em_estimates}}.}
}
\value{
A scalar, the (logarithm of the) ZIP statistic.
}
\description{
Calculate the single-window statistic for the zero-inflated Poisson 
distribution using the EM algorithm.
}
\keyword{internal}

