% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting_Seurat.R
\name{FeaturePlot_scCustom}
\alias{FeaturePlot_scCustom}
\title{Customize FeaturePlot}
\usage{
FeaturePlot_scCustom(
  seurat_object,
  features,
  colors_use = viridis_plasma_dark_high,
  na_color = "lightgray",
  order = TRUE,
  pt.size = NULL,
  reduction = NULL,
  na_cutoff = 1e-09,
  raster = NULL,
  raster.dpi = c(512, 512),
  split.by = NULL,
  split_collect = NULL,
  aspect_ratio = NULL,
  figure_plot = FALSE,
  num_columns = NULL,
  layer = "data",
  alpha_exp = NULL,
  alpha_na_exp = NULL,
  label = FALSE,
  label_feature_yaxis = FALSE,
  max.cutoff = NA,
  min.cutoff = NA,
  combine = TRUE,
  ...
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{features}{Feature(s) to plot.}

\item{colors_use}{list of colors or color palette to use.}

\item{na_color}{color to use for points below lower limit.}

\item{order}{whether to move positive cells to the top (default = TRUE).}

\item{pt.size}{Adjust point size for plotting.}

\item{reduction}{Dimensionality Reduction to use (if NULL then defaults to Object default).}

\item{na_cutoff}{Value to use as minimum expression cutoff.  This will be lowest value plotted use
palette provided to \code{colors_use}.  Leave as default value to plot only positive non-zero values using
color scale and zero/negative values as NA.  To plot all values using color palette set to \code{NA}.}

\item{raster}{Convert points to raster format.  Default is NULL which will rasterize by default if
greater than 200,000 cells.}

\item{raster.dpi}{Pixel resolution for rasterized plots, passed to geom_scattermore().
Default is c(512, 512).}

\item{split.by}{Variable in \verb{@meta.data} to split the plot by.}

\item{split_collect}{logical, whether to collect the legends/guides when plotting with \code{split.by}.
Default is TRUE if one value is provided to \code{features} otherwise is set to FALSE.}

\item{aspect_ratio}{Control the aspect ratio (y:x axes ratio length).  Must be numeric value;
Default is NULL.}

\item{figure_plot}{logical.  Whether to remove the axes and plot with legend on left of plot denoting
axes labels.  (Default is FALSE).  Requires \code{split_seurat = TRUE}.}

\item{num_columns}{Number of columns in plot layout.}

\item{layer}{Which layer to pull expression data from?  Default is "data".}

\item{alpha_exp}{new alpha level to apply to expressing cell color palette (\code{colors_use}).  Must be
value between 0-1.}

\item{alpha_na_exp}{new alpha level to apply to non-expressing cell color palette (\code{na_color}).  Must be
value between 0-1.}

\item{label}{logical, whether to label the clusters.  Default is FALSE.}

\item{label_feature_yaxis}{logical, whether to place feature labels on secondary y-axis as opposed to
above legend key.  Default is FALSE.  When setting \code{label_feature_yaxis = TRUE} the number of columns
in plot output will automatically be set to the number of levels in \verb{split.by'}.}

\item{min.cutoff, max.cutoff}{Vector of minimum and maximum cutoff values for each feature,
may specify quantile in the form of 'q##' where '##' is the quantile (eg, 'q1', 'q10').}

\item{combine}{Combine plots into a single \code{\link[patchwork]{patchwork}ed} ggplot object.
If FALSE, return a list of ggplot objects.}

\item{...}{Extra parameters passed to \code{\link[Seurat]{FeaturePlot}}.}
}
\value{
A ggplot object
}
\description{
Create Custom FeaturePlots and preserve scale (no binning)
}
\examples{
library(Seurat)
FeaturePlot_scCustom(seurat_object = pbmc_small, features = "CD3E",
colors_use = viridis_plasma_dark_high, na_color = "lightgray")

}
\concept{seurat_plotting}
