% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_word_coverage.R
\name{plot.word_coverage}
\alias{plot.word_coverage}
\title{Plot method for word_coverage objects}
\usage{
\method{plot}{word_coverage}(
  x,
  include_EOS = FALSE,
  show_limit = TRUE,
  type = "l",
  xlim = c(0, length(x)),
  ylim = c(0, 1),
  xticks = seq(from = 0, to = length(x), by = length(x)/5),
  yticks = seq(from = 0, to = 1, by = 0.25),
  xlab = "Rank",
  ylab = "Covered fraction",
  title = "Cumulative corpus coverage fraction of dictionary",
  subtitle = "_default_",
  ...
)
}
\arguments{
\item{x}{a \code{word_coverage} object.}

\item{include_EOS}{length one logical. Should End-Of-Sentence tokens be
considered in the computation of coverage fraction?}

\item{show_limit}{length one logical. If \code{TRUE}, plots an horizontal
line corresponding to the total coverage fraction.}

\item{type}{what type of plot should be drawn, as detailed in \code{?plot}.}

\item{xlim}{length two numeric. Extremes of the x-range.}

\item{ylim}{length two numeric. Extremes of the y-range.}

\item{xticks}{numeric vector. position of the x-axis ticks.}

\item{yticks}{numeric vector. position of the y-axis ticks.}

\item{xlab}{length one character. The x-axis label.}

\item{ylab}{length one character. The y-axis label.}

\item{title}{length one character. Plot title.}

\item{subtitle}{length one character. Plot subtitle; if "\emph{default}", prints
dictionary length and total covered fraction.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Plot cumulative corpus coverage fraction of a dictionary.
}
\details{
This function generates nice plots of cumulative corpus coverage
fractions. The \code{x} coordinate in the resulting plot is the word rank in the
underlying dictionary; the \code{y} coordinate at
\code{x} is the cumulative coverage fraction for \code{rank <= x}.
}
\examples{
\donttest{
c <- word_coverage(twitter_dict, twitter_test)
plot(c)
}
}
\author{
Valerio Gherardi
}
