% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Class-SBM_sampler.R
\name{SBM_sampler}
\alias{SBM_sampler}
\title{R6 class for SBM sampler}
\description{
R6 class for SBM sampler

R6 class for SBM sampler
}
\section{Super class}{
\code{\link[sbm:SBM]{sbm::SBM}} -> \code{SBM_sampler}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{variance}}{variance of each dyad under the current model}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{SBM_sampler$new()}}
\item \href{#method-show}{\code{SBM_sampler$show()}}
\item \href{#method-clone}{\code{SBM_sampler$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="sbm" data-topic="SBM" data-id="plot">}\href{../../sbm/html/SBM.html#method-plot}{\code{sbm::SBM$plot()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="sbm" data-topic="SBM" data-id="print">}\href{../../sbm/html/SBM.html#method-print}{\code{sbm::SBM$print()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constructor for SBM
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SBM_sampler$new(
  model,
  nbNodes,
  blockProp,
  dimLabels,
  connectParam,
  covarParam = numeric(0),
  covarList = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{character describing the type of model}

\item{\code{nbNodes}}{number of nodes in the network}

\item{\code{blockProp}}{parameters for block proportions (vector of list of vectors)}

\item{\code{dimLabels}}{labels of each dimension (in row, in column)}

\item{\code{connectParam}}{list of parameters for connectivity with a matrix of means 'mean' and an optional scalar for the variance 'var'. The dimensions of mu must match \code{blockProp} lengths}

\item{\code{covarParam}}{optional vector of covariates effect}

\item{\code{covarList}}{optional list of covariates data}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-show"></a>}}
\if{latex}{\out{\hypertarget{method-show}{}}}
\subsection{Method \code{show()}}{
print/show method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SBM_sampler$show(type = "Sampler for a Stochastic Block Model")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{character to tune the displayed name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SBM_sampler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
