% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.snowprofile.R
\name{plot.snowprofile}
\alias{plot.snowprofile}
\title{Plot hardness profile}
\usage{
\method{plot}{snowprofile}(
  x,
  TempProfile = TRUE,
  Col = sapply(x$layers$gtype, getColoursGrainType),
  TopDown = FALSE,
  axes = TRUE,
  xlab = "",
  emphasizeLayers = FALSE,
  emphasis = "95",
  failureLayers = FALSE,
  failureLayers.cex = 1,
  ...
)
}
\arguments{
\item{x}{\link{snowprofile} object}

\item{TempProfile}{draw unscaled temperature profile (default = TRUE)}

\item{Col}{vector of colours corresponding to the grain types in the profile (defaults to a lookup table)}

\item{TopDown}{Option to plot by depth instead of height with zero depth on top of plot (default = FALSE)}

\item{axes}{Should axes be printed?}

\item{xlab}{x-axis label, defaults to an empty string}

\item{emphasizeLayers}{index OR character vector (grain types) of layers to be emphasized (i.e. all other layers become slightly transparent)}

\item{emphasis}{2 digit quoted number between \code{'01'}-\code{'99'} to control the degree of emphasis; the higher the stronger}

\item{failureLayers}{height vector of failure layers that will be indicated with a red arrow}

\item{failureLayers.cex}{factor to shrink or enlarge the arrow}

\item{...}{other parameters to barplot}
}
\description{
Plot hardness profile
}
\examples{

plot(SPpairs$A_manual)
plot(SPpairs$A_manual, Col = 'black')
plot(SPpairs$A_manual, emphasizeLayers = c(5, 11),
     failureLayers = SPpairs$A_manual$layers$height[5], failureLayers.cex = 1.5)
plot(SPpairs$A_manual, emphasizeLayers = 'SH')
plot(SPpairs$A_manual, TopDown = TRUE)

}
\seealso{
\link{plot.snowprofileSet}
}
