% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_grouping}
\alias{get_grouping}
\title{Generate a matrix of group membership for all individuals}
\usage{
get_grouping(ind, group)
}
\arguments{
\item{ind}{vector of subject identifier (individual) for each observation}

\item{group}{vector of group membership for each observation}
}
\value{
\code{data.frame} with as rows each unique Individual ID and 2 columns (ind and group).
}
\description{
Establish the group membership of individuals based on the metadata across all observations using the vector of subject identifier and the matching vector of group membership.
}
\examples{
## 3 subjets in 2 groups
ind   <- c('ind_1','ind_1','ind_1','ind_2','ind_2','ind_3')
group <- c('g1','g1','g1','g2','g2','g1')
get_grouping(ind, group)
#     ind group
# 1 ind_1    g1
# 2 ind_2    g2
# 3 ind_3    g1

## 8 subjects in 2 groups
ind   <- acuteInflammation$meta$ind
group <- acuteInflammation$meta$group
get_grouping(ind, group)
#    ind   group
# 1 ind_1 Group1
# 2 ind_2 Group2
# 3 ind_3 Group1
# 4 ind_4 Group2
# 5 ind_5 Group1
# 6 ind_6 Group2
# 7 ind_7 Group1
# 8 ind_8 Group2

}
\seealso{
Other Analysis: 
\code{\link{get_ind_time_matrix}()},
\code{\link{santaR_CBand}()},
\code{\link{santaR_auto_fit}()},
\code{\link{santaR_auto_summary}()},
\code{\link{santaR_fit}()},
\code{\link{santaR_plot}()},
\code{\link{santaR_pvalue_dist}()},
\code{\link{santaR_pvalue_fit}()},
\code{\link{santaR_start_GUI}()}
}
\concept{Analysis}
