% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelMRHLP.R
\docType{class}
\name{ModelMRHLP-class}
\alias{ModelMRHLP-class}
\alias{ModelMRHLP}
\title{A Reference Class which represents a fitted MRHLP model.}
\description{
ModelMRHLP represents an estimated MRHLP model.
}
\section{Fields}{

\describe{
\item{\code{param}}{A \link{ParamMRHLP} object. It contains the estimated
values of the parameters.}

\item{\code{stat}}{A \link{StatMRHLP} object. It contains all the statistics
associated to the MRHLP model.}
}}

\section{Methods}{

\describe{
\item{\code{plot(what = c("regressors", "estimatedsignal", "loglikelihood"), ...)}}{Plot method.
\describe{
  \item{\code{what}}{The type of graph requested:
    \itemize{
      \item \code{"regressors" = } Polynomial regression components
        (fields \code{polynomials} and \code{pi_ik} of class
        \link{StatMRHLP}).
      \item \code{"estimatedsignal" = } Estimated signal (fields
        \code{Ex} and \code{klas} of class \link{StatMRHLP}).
      \item \code{"loglikelihood" = } Value of the log-likelihood for
        each iteration (field \code{stored_loglik} of class
        \link{StatMRHLP}).
    }
  }
  \item{\code{\dots}}{Other graphics parameters.}
}
By default, all the graphs mentioned above are produced.}

\item{\code{summary(digits = getOption("digits"))}}{Summary method.
\describe{
  \item{\code{digits}}{The number of significant digits to use when
    printing.}
}}
}}

\examples{
data(multivtoydataset)

mrhlp <- emMRHLP(multivtoydataset$x, multivtoydataset[,c("y1", "y2", "y3")],
                 K = 5, p = 1, verbose = TRUE)

# mrhlp is a ModelMRHLP object. It contains some methods such as 'summary' and 'plot'
mrhlp$summary()
mrhlp$plot()

# mrhlp has also two fields, stat and param which are reference classes as well

# Log-likelihood:
mrhlp$stat$loglik

# Parameters of the polynomial regressions:
mrhlp$param$beta
}
\seealso{
\link{ParamMRHLP}, \link{StatMRHLP}
}
