% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{parameterized_search_control}
\alias{parameterized_search_control}
\title{Auxiliary for Controlling Parametrized Searches}
\usage{
parameterized_search_control(
  objects = NULL,
  fields_scope = c("ALL", "NAME", "EMAIL", "PHONE", "SIDEBAR"),
  fields = NULL,
  overall_limit = 2000,
  default_limit = 200,
  spell_correction = TRUE
)
}
\arguments{
\item{objects}{\code{character}; objects to search and return in the response. Multiple
objects can be provided as a character vector}

\item{fields_scope}{\code{character}; scope of fields to search in order to limit the resources
used and improve performance}

\item{fields}{\code{character}; one or more fields to return in the response for each
sobject specified. If no fields are specified only the Ids of the matching records
are returned.}

\item{overall_limit}{\code{numeric}; the maximum number of results to return across
all objects in the search.}

\item{default_limit}{\code{numeric}; the maximum number of results to return for
each of the specified objects. This parameter is ignored if the \code{objects} argument
is left \code{NULL}.}

\item{spell_correction}{\code{logical}; specifies whether spell correction should be
enabled for a user’s search.}
}
\value{
\code{list} of parameters passed onto sf_search
}
\description{
A function for allowing finer grained control over how a search is performed
when not using SOSL
}
\examples{
\dontrun{
# free text search only on Contact record Phone fields
# this will improve the performance of the search
my_phone_search <- "(336)"
search_result <- sf_search(my_phone_search,
                           objects = c("Contact", "Lead"),
                           fields_scope = "PHONE",
                           fields = c("Id", "FirstName", "LastName"))
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_rest.meta/api_rest/resources_search_parameterized.htm#resources_search_parameterized}
}
