% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-org.R
\name{sf_empty_recycle_bin}
\alias{sf_empty_recycle_bin}
\title{Empty Recycle Bin}
\usage{
sf_empty_recycle_bin(ids, api_type = c("SOAP"), verbose = FALSE)
}
\arguments{
\item{ids}{\code{vector}, \code{matrix}, \code{data.frame}, or 
\code{tbl_df}; if not a vector, there must be a column called Id (case-insensitive) 
that can be passed in the request}

\item{api_type}{character; one of "REST", "SOAP", "Bulk 1.0", "Bulk 2.0", or 
"Chatter" indicating which API to use when making the request}

\item{verbose}{logical; do you want informative messages?}
}
\value{
\code{tbl_df} of records with success indicator
}
\description{
Delete records from the recycle bin immediately and permanently.
}
\details{
When emptying recycle bins, consider the following rules and guidelines:
\itemize{
  \item The logged in user can delete any record that he or she can query in their Recycle Bin, or the recycle bins of any subordinates. If the logged in user has Modify All Data permission, he or she can query and delete records from any Recycle Bin in the organization.
  \item Do not include the IDs of any records that will be cascade deleted, or an error will occur.
  \item Once records are deleted using this call, they cannot be undeleted using \code{link{sf_undelete}}
  \item After records are deleted from the Recycle Bin using this call, they can be queried using the \code{queryall} argument for some time. Typically this time is 24 hours, but may be shorter or longer.
}
}
\examples{
\dontrun{
new_contact <- c(FirstName = "Test", LastName = "Contact")
new_records <- sf_create(new_contact, object_name = "Contact")
delete <- sf_delete(new_records$id[1],
                    AllOrNoneHeader = list(allOrNone = TRUE))
is_deleted <- sf_query(sprintf("SELECT Id, IsDeleted FROM Contact WHERE Id='\%s'",
                       new_records$id[1]),
                       queryall = TRUE)
hard_deleted <- sf_empty_recycle_bin(new_records$id[1])

# confirm that the record really is gone (can't be deleted)
undelete <- sf_undelete(new_records$id[1])
# if you use queryall you still will find the record for ~24hrs
#is_deleted <- sf_query(sprintf("SELECT Id, IsDeleted FROM Contact WHERE Id='\%s'",
#                               new_records$id[1]),
#                       queryall = TRUE)
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api.meta/api/sforce_api_calls_emptyrecyclebin.htm}
}
