% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{sf_update}
\alias{sf_update}
\title{Update Records}
\usage{
sf_update(input_data, object_name, all_or_none = FALSE, api_type = c("SOAP",
  "REST", "Bulk 1.0", "Bulk 2.0"), ..., verbose = FALSE)
}
\arguments{
\item{input_data}{\code{named vector}, \code{matrix}, \code{data.frame}, or 
\code{tbl_df}; data can be coerced into a \code{data.frame}}

\item{object_name}{character; the name of one Salesforce objects that the 
function is operating against (e.g. "Account", "Contact", "CustomObject__c")}

\item{all_or_none}{logical; allows a call to roll back all changes unless all 
records are processed successfully}

\item{api_type}{character; one of "REST", "SOAP", or "Bulk" indicating 
which API to use when making the request}

\item{...}{Other arguments passed on to \code{\link{sf_bulk_operation}}.}

\item{verbose}{logical; do you want informative messages?}
}
\value{
\code{tbl_df} of records with success indicator
}
\description{
Updates one or more records to your organization’s data.
}
\examples{
\dontrun{
n <- 3
new_contacts <- tibble(FirstName = rep("Test", n),
                       LastName = paste0("Contact", 1:n))
new_contacts_result <- sf_create(new_contacts, "Contact")

update_contacts <- tibble(FirstName = rep("TestTest", n),
                          LastName = paste0("Contact", 1:n), 
                          Id = new_contacts_result$id)
updated_contacts_result1 <- sf_update(update_contacts, "Contact")
updated_contacts_result2 <- sf_update(update_contacts, "Contact", 
                                      api_type="Bulk")
}
}
