% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setMappingListValue.R
\name{setMappingListValue}
\alias{setMappingListValue}
\title{Set the value for a given named parameter}
\usage{
setMappingListValue(key, value, settings, forceCreate = FALSE)
}
\arguments{
\item{key}{a list defining the position of parameter in the settings object.}

\item{value}{the value to set}

\item{settings}{The settings list used to generate a chart like \code{eDISH()}}

\item{forceCreate}{Specifies whether the function should create a new list() when none exisits. This most commonly occurs when deeply nested objects.}
}
\value{
the updated settings object
}
\description{
Sets the value for a named parameter (\code{key}) to given \code{value} in a list (\code{settings})
}
\examples{
testSet<-list(a=list(b="myValue"))
safetyGraphics:::setMappingListValue(key=list("a","b"), value="notMyValue", settings=testSet) 
#returns list(a=list(b="notMyValue")))

}
\keyword{internal}
