% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_cols.R
\name{compare_cols}
\alias{compare_cols}
\title{Compares contents of 2 vectors}
\usage{
compare_cols(data_cols, standard_cols)
}
\arguments{
\item{data_cols}{A character vector with column names in the data frame}

\item{standard_cols}{A character vector with column names in the data standard}
}
\value{
A list summarizing the comparison between \code{data_cols} and \code{standard_cols}. List has character vectors for "matched_columns", "extra_columns" and "missing_columns" parameters, and a boolean "match" parameter indicating that there are no missing columns.
}
\description{
Function to compare contents of 2 vectors - used to summarize of which data columns are found in a given standard. Used in \code{detectStandard()} and \code{validateSettings()}
}
\examples{
#match == FALSE
safetyGraphics:::compare_cols(data_cols=c("a","b","c"),
                              standard_cols=c("d","e","f")) 

# match == TRUE
safetyGraphics:::compare_cols(names(adlbc),
                              safetyGraphics:::getRequiredColumns(standard="ADaM")) 

}
