% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zTest.R
\name{designSafeZ}
\alias{designSafeZ}
\title{Designs a Safe Z Experiment}
\usage{
designSafeZ(
  meanDiffMin = NULL,
  beta = NULL,
  nPlan = NULL,
  alpha = 0.05,
  h0 = 0,
  alternative = c("two.sided", "greater", "less"),
  sigma = 1,
  kappa = sigma,
  tol = 1e-05,
  testType = c("oneSample", "paired", "twoSample"),
  ratio = 1,
  parameter = NULL,
  nSim = 1000L,
  nBoot = 1000L,
  pb = TRUE,
  grow = TRUE,
  ...
)
}
\arguments{
\item{meanDiffMin}{numeric that defines the minimal relevant mean difference, the smallest population mean
that we would like to detect.}

\item{beta}{numeric in (0, 1) that specifies the tolerable type II error control necessary to calculate both "n"
and "phiS". Note that 1-beta defines the power.}

\item{nPlan}{optional numeric vector of length at most 2. When provided, it is used to find the safe test
defining parameter phiS. Note that if the purpose is to plan based on nPlan alone, then both meanDiffMin
and beta should be set to NULL.}

\item{alpha}{numeric in (0, 1) that specifies the tolerable type I error control --independent on n-- that the
designed test has to adhere to. Note that it also defines the rejection rule e10 > 1/alpha.}

\item{h0}{numeric, represents the null hypothesis, default h0=0.}

\item{alternative}{a character string specifying the alternative hypothesis must be one of "two.sided" (default),
"greater" or "less".}

\item{sigma}{numeric > 0 representing the assumed population standard deviation used for the test.}

\item{kappa}{the true population standard deviation. Default kappa=sigma.}

\item{tol}{a number that defines the stepsizes between the lowParam and highParam.}

\item{testType}{either one of "oneSample", "paired", "twoSample".}

\item{ratio}{numeric > 0 representing the randomisation ratio of condition 2 over condition 1. If testType
is not equal to "twoSample", or if nPlan is of length(1) then ratio=1.}

\item{parameter}{optional test defining parameter. Default set to \code{NULL}.}

\item{nSim}{integer > 0, the number of simulations needed to compute power or the number of samples paths
for the safe z test under continuous monitoring.}

\item{nBoot}{integer > 0 representing the number of bootstrap samples to assess the accuracy of
approximation of the power, the number of samples for the safe z test under continuous monitoring,
or for the computation of the logarithm of the implied target.}

\item{pb}{logical, if \code{TRUE}, then show progress bar.}

\item{grow}{logical, default set to \code{TRUE} so the grow safe test is used in the design.}

\item{...}{further arguments to be passed to or from methods.}
}
\value{
Returns a safeDesign object that includes:

\describe{
  \item{nPlan}{the sample size(s) to plan for. Computed based on beta and meanDiffMin, or provided by the user
  if known.}
  \item{parameter}{the safe test defining parameter. Here phiS.}
  \item{esMin}{the minimally clinically relevant effect size provided by the user.}
  \item{alpha}{the tolerable type I error provided by the user.}
  \item{beta}{the tolerable type II error specified by the user.}
  \item{alternative}{any of "two.sided", "greater", "less" provided by the user.}
  \item{testType}{any of "oneSample", "paired", "twoSample" effectively provided by the user.}
  \item{paired}{logical, \code{TRUE} if "paired", \code{FALSE} otherwise.}
  \item{sigma}{the assumed population standard deviation used for the test provided by the user.}
  \item{kappa}{the true population standard deviation, typically, sigma=kappa.}
  \item{ratio}{default is 1. Different from 1, whenever testType equals "twoSample", then it defines
  ratio between the planned randomisation of condition 2 over condition 1.}
  \item{tol}{the step size between parameter values in the candidate space.}
  \item{pilot}{logical, specifying whether it's a pilot design.}
  \item{call}{the expression with which this function is called.}
}
}
\description{
A designed experiment requires (1) a sample size nPlan to plan for, and (2) the parameter of the safe test, i.e.,
phiS. Provided with a clinically relevant minimal mean difference meanDiffMin, this function outputs
phiS = meanDiffMin as the safe test defining parameter in accordance to the GROW criterion.
If a tolerable type II error, i.e., beta, is provided then nPlan can be sampled. The sampled nPlan is then
the smallest nPlan for which meanDiffMin can be found with power at least 1 - beta under optional stopping.
}
\examples{
designObj <- designSafeZ(meanDiffMin=0.8, alpha=0.08, beta=0.01, alternative="greater")

#nPlan known:
designObj <- designSafeZ(nPlan = 100, alpha=0.05)

}
\references{
Grunwald, de Heide and Koolen (2019) "Safe Testing" <arXiv:1906.07801>
}
