% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tTest.R
\name{computeBetaSafeT}
\alias{computeBetaSafeT}
\title{Helper function: Computes the type II error of the safeTTest based on the minimal clinically relevant
standardised mean difference and nPlan.}
\usage{
computeBetaSafeT(
  deltaMin,
  nPlan,
  alpha = 0.05,
  alternative = c("two.sided", "greater", "less"),
  testType = c("oneSample", "paired", "twoSample"),
  seed = NULL,
  parameter = NULL,
  pb = TRUE,
  nSim = 1000L,
  nBoot = 1000L
)
}
\arguments{
\item{deltaMin}{numeric that defines the minimal relevant standardised effect size, the smallest effect size that
we would the experiment to be able to detect.}

\item{nPlan}{vector of max length 2 representing the planned sample sizes.}

\item{alpha}{numeric in (0, 1) that specifies the tolerable type I error control --independent of n-- that the
designed test has to adhere to. Note that it also defines the rejection rule e10 > 1/alpha.}

\item{alternative}{a character string specifying the alternative hypothesis must be one of "two.sided" (default),
"greater" or "less".}

\item{testType}{either one of "oneSample", "paired", "twoSample".}

\item{seed}{integer, seed number.}

\item{parameter}{optional test defining parameter. Default set to \code{NULL}.}

\item{pb}{logical, if \code{TRUE}, then show progress bar.}

\item{nSim}{integer > 0, the number of simulations needed to compute power or the number of samples paths
for the safe z test under continuous monitoring.}

\item{nBoot}{integer > 0 representing the number of bootstrap samples to assess the accuracy of
approximation of the power, the number of samples for the safe z test under continuous monitoring,
or for the computation of the logarithm of the implied target.}
}
\value{
a list which contains at least beta and an adapted bootObject of class
\code{\link[boot]{boot}}.
}
\description{
Helper function: Computes the type II error of the safeTTest based on the minimal clinically relevant
standardised mean difference and nPlan.
}
\examples{
computeBetaSafeT(deltaMin=0.7, 27, nSim=10)
}
