% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elu.R
\name{dELU}
\alias{dELU}
\alias{d2ELU}
\alias{d2aELU}
\alias{dELUa}
\alias{d2ELUa}
\title{Derivatives of the Exponential Linear Unit (ELU) Activation Function}
\usage{
dELU(x, alpha = 1)

d2ELU(x, alpha = 1)

d2aELU(x, alpha = 1)

dELUa(x, alpha = 1)

d2ELUa(x, alpha = 1)
}
\arguments{
\item{x}{A numeric vector. All elements must be finite and
non-missing.}

\item{alpha}{A numeric scalar. All elements must be finite and
non-missing.}
}
\value{
A numeric vector where the derivative(s) of the ELU function has been applied
to each element of \code{x}.
}
\description{
Derivatives of the Exponential Linear Unit (ELU) Activation Function
}
\examples{
dELU(c(-1, 0, 1, 2), 2)
d2ELU(c(-1, 0, 1, 2), 2)
d2aELU(c(-1, 0, 1, 2), 2)
dELUa(c(-1, 0, 1, 2), 2)
d2ELUa(c(-1, 0, 1, 2), 2)

# Can also be used in rxode2:
r <- rxode2({
  r1=dELU(time, 2)
  r2=d2ELU(time, 2)
  r2a=d2aELU(time, 2)
  ra=dELUa(time, 2)
  r2a=d2ELUa(time, 2)
})

e <- et(c(-1, 0, 1, 2))
rxSolve(r, e)
}
\seealso{
Other Activation Functions: 
\code{\link{ELU}()},
\code{\link{GELU}()},
\code{\link{PReLU}()},
\code{\link{ReLU}()},
\code{\link{SELU}()},
\code{\link{Swish}()},
\code{\link{dGELU}()},
\code{\link{dPReLU}()},
\code{\link{dReLU}()},
\code{\link{dSELU}()},
\code{\link{dSwish}()},
\code{\link{dlReLU}()},
\code{\link{dsoftplus}()},
\code{\link{lReLU}()},
\code{\link{softplus}()}
}
\author{
Matthew L. Fidler
}
\concept{Activation Functions}
