% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piping-model.R, R/ui.R
\name{model.function}
\alias{model.function}
\alias{model.rxUi}
\alias{model.rxode2}
\alias{model.rxModelVars}
\alias{model}
\alias{model.default}
\title{Model block for rxode2/nlmixr models}
\usage{
\method{model}{`function`}(x, ..., append = FALSE, auto = TRUE, envir = parent.frame())

\method{model}{rxUi}(x, ..., append = FALSE, auto = TRUE, envir = parent.frame())

\method{model}{rxode2}(x, ..., append = FALSE, auto = TRUE, envir = parent.frame())

\method{model}{rxModelVars}(x, ..., append = FALSE, auto = TRUE, envir = parent.frame())

model(
  x,
  ...,
  append = FALSE,
  auto = getOption("rxode2.autoVarPiping", TRUE),
  envir = parent.frame()
)

\method{model}{default}(x, ..., append = FALSE, envir = parent.frame())
}
\arguments{
\item{x}{model expression}

\item{...}{Other arguments}

\item{append}{This is a boolean to determine if the lines are
appended in piping.  The possible values for this is:
\itemize{
\item \code{TRUE} which is when the lines are appended to the model instead of replaced
\item \code{FALSE} when the lines are replaced in the model (default)
\item \code{NA} is when the lines are pre-pended to the model instead of replaced
\item \verb{lhs expression}, which will append the lines after the last observed line of the expression \code{lhs}
}}

\item{auto}{This boolean tells if piping automatically selects the
parameters should be characterized as a population parameter,
between subject variability, or a covariate.  When \code{TRUE} this
automatic selection occurs.  When \code{FALSE} this automatic
selection is turned off and everything is added as a covariate
(which can be promoted to a parameter with the \code{ini} statement).
By default this is \code{TRUE}, but it can be changed by
\code{options(rxode2.autoVarPiping=FALSE)}.}

\item{envir}{the \code{environment} in which unevaluated model
expressions is to be evaluated.  May also be \code{NULL}, a list, a
data frame, a pairlist or an integer as specified to \code{sys.call}.}
}
\value{
Model block with ini information included.  \code{ini} must be
called before \code{model} block
}
\description{
Model block for rxode2/nlmixr models
}
\author{
Matthew Fidler
}
