% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treespace.R
\name{treespace}
\alias{treespace}
\title{MDS scaling of treespace for a single tree list.}
\usage{
treespace(chains, n.points = 100, burnin = 0, fill.color = NA)
}
\arguments{
\item{chains}{A list of 1 or more rwty.trees objects.}

\item{n.points}{The minimum number of points you want in your plot.}

\item{burnin}{The number of trees to eliminate as burnin. Default is zero.}

\item{fill.color}{The name of the column from the log table that that you would like to use to colour the points in the plot.}
}
\value{
Returns a list containing the points and a plot.
}
\description{
This function constructs a distance matrix from a list of trees
and uses multi-dimensional scaling to collapse it to a two-
dimensional tree space for plotting.
}
\examples{
data(fungus)
treespace(fungus, n.points=50, burnin=20, fill.color="LnL")
}
\keyword{mds,}
\keyword{multi-dimensional}
\keyword{scaling}
\keyword{treespace,}

