% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/w_series_list.R
\name{w_series_list}
\alias{w_series_list}
\title{List the available series from a dataset.}
\usage{
w_series_list(dataset_name, language = "fr", client_ID)
}
\arguments{
\item{dataset_name}{Mandatory. String (Must be between quotes.) The datasets codes can be determined with the w_datasets() function.}

\item{language}{Optional. String. Defaults to "fr" (French). The only other available option is "en" (English). Determines the language of the metadata. Your Webstat "App" must be subscribed to the API in this language (or both) or you'll get a 501 http error.}

\item{client_ID}{Optional. String. If you do not specify it when calling the function, it will check if a global variable called ".GlobalEnv$webstat_client_ID exists and use it. If not, you will be prompted. The easiest way is to save the client ID as a string in ".GlobalEnv$webstat_client_ID".}
}
\value{
A data frame listing all the series from the requested dataset with their codes, titles and dimensions.
}
\description{
List the available series from a dataset.
}
\section{Identification}{

You should declare your Webstat client ID in a global "webstat_client_ID" variable. Alternatively, you can enter your client ID as a parameter or enter it when prompted.
}

\examples{
\donttest{
## Request the list of all series from the BPM6 dataset
w_series_list("BPM6")

## Request the list of all series from the CPP dataset, with English metadata
w_series_list("CPP", language = "en")

\dontrun{
## Your client ID can be entered as a parameter as follows or saved
## in a global variable named "webstat_client_ID" in order to reuse it.
w_series_list("CPP", client_ID = "1234abcd-12ab-12ab-12ab-123456abcdef") 
}
}

}
