% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_mean.R
\name{weighted_mean}
\alias{weighted_mean}
\alias{weighted_mean.default}
\alias{weighted_mean.rvec}
\alias{weighted_mad}
\alias{weighted_mad.default}
\alias{weighted_mad.rvec}
\alias{weighted_median}
\alias{weighted_median.default}
\alias{weighted_median.rvec}
\alias{weighted_sd}
\alias{weighted_sd.default}
\alias{weighted_sd.rvec}
\alias{weighted_var}
\alias{weighted_var.default}
\alias{weighted_var.rvec}
\title{Calculate Weighted Summaries}
\usage{
weighted_mean(x, wt = NULL, na_rm = FALSE)

\method{weighted_mean}{default}(x, wt = NULL, na_rm = FALSE)

\method{weighted_mean}{rvec}(x, wt = NULL, na_rm = FALSE)

weighted_mad(x, wt = NULL, na_rm = FALSE)

\method{weighted_mad}{default}(x, wt = NULL, na_rm = FALSE)

\method{weighted_mad}{rvec}(x, wt = NULL, na_rm = FALSE)

weighted_median(x, wt = NULL, na_rm = FALSE)

\method{weighted_median}{default}(x, wt = NULL, na_rm = FALSE)

\method{weighted_median}{rvec}(x, wt = NULL, na_rm = FALSE)

weighted_sd(x, wt = NULL, na_rm = FALSE)

\method{weighted_sd}{default}(x, wt = NULL, na_rm = FALSE)

\method{weighted_sd}{rvec}(x, wt = NULL, na_rm = FALSE)

weighted_var(x, wt = NULL, na_rm = FALSE)

\method{weighted_var}{default}(x, wt = NULL, na_rm = FALSE)

\method{weighted_var}{rvec}(x, wt = NULL, na_rm = FALSE)
}
\arguments{
\item{x}{Quantity being summarised.
An ordinary vector or an \link[=rvec]{rvec}.}

\item{wt}{Weights. An ordinary vector,
an \link[=rvec]{rvec}, or \code{NULL} (the default.)
If \code{NULL}, an unweighted summary is returned.}

\item{na_rm}{Whether to remove \code{NA}s
in \code{x} or \code{wt} before calculating.
Default is \code{FALSE}.
See
\code{\link[matrixStats:weightedMean]{matrixStats::weightedMean()}} for a description
of the algorithm used.}
}
\value{
If \code{x} or \code{wt} or is \link[=rvec]{rvec},
then an rvec of length 1. Otherwise, a scalar.
}
\description{
Calculate weighted
\itemize{
\item means
\item medians
\item MADs (mean absolute deviations)
\item variances
\item standard deviations.
}

These functions all work with ordinary vectors
and with \link[=rvec]{rvecs}.
}
\details{
\code{x} and \code{wt} must have the same length.

Internally the calculations are done by
\href{https://CRAN.R-project.org/package=matrixStats}{matrixStats}
functions such as \code{\link[matrixStats:weightedMean]{matrixStats::weightedMean()}}
and \code{\link[matrixStats:rowWeightedMeans]{matrixStats::colWeightedMeans()}}.
}
\examples{
## 'x' is rvec, 'wt' is ordinary vector
v <- rvec(list(c(1, 11),
               c(2, 12),
               c(7, 17)))
weights <- c(40, 80, 72)
weighted_mean(v, wt = weights)

## 'x' is ordinary vector, 'wt' is rvec
y <- c(1, 2, 3)
w <- rvec(list(c(100, 200),
               c(210, 889),
               c(200, 200)))
weighted_mean(y, wt = w)
weighted_mean(y, wt = w, na_rm = TRUE)
}
\seealso{
\itemize{
\item Functions \code{\link[=mean]{mean()}}, \code{\link[=median]{median()}},
\code{\link[=mad]{mad()}}, \code{\link[=var]{var()}}, \code{\link[=sd]{sd()}} for unweighted data
all have methods for rvecs
\item The original
\href{https://CRAN.R-project.org/package=matrixStats}{matrixStats}
weighted summary functions have additional options
not implemented in the functions here.
\item \code{\link[=weighted.mean]{weighted.mean()}} is a base R function for weighted data
\item For numeric summaries of draws in an rvec,
use \code{\link[=draws_median]{draws_median()}}, \link{draws_mean}, \code{\link[=draws_quantile]{draws_quantile()}},
\code{\link[=draws_fun]{draws_fun()}}.
}
}
