% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sugar.R
\name{rsh}
\alias{rsh}
\title{Synctatic Sugar for Rush Controller Construction}
\usage{
rsh(network_id = NULL, config = NULL, seed = NULL, ...)
}
\arguments{
\item{network_id}{(\code{character(1)})\cr
Identifier of the rush network.
Controller and workers must have the same instance id.
Keys in Redis are prefixed with the instance id.}

\item{config}{(\link[redux:redis_config]{redux::redis_config})\cr
Redis configuration options.
If \code{NULL}, configuration set by \code{\link[=rush_plan]{rush_plan()}} is used.
If \code{rush_plan()} has not been called, the \code{REDIS_URL} environment variable is parsed.
If \code{REDIS_URL} is not set, a default configuration is used.
See \link[redux:redis_config]{redux::redis_config} for details.}

\item{seed}{(\code{integer()})\cr
Initial seed for the random number generator.
Either a L'Ecuyer-CMRG seed (\code{integer(7)}) or a regular RNG seed (\code{integer(1)}).
The later is converted to a L'Ecuyer-CMRG seed.
If \code{NULL}, no seed is used for the random number generator.}

\item{...}{(ignored).}
}
\value{
\link{Rush} controller.
}
\description{
Function to construct a \link{Rush} controller.
}
\examples{
# This example is not executed since Redis must be installed
\donttest{
   config_local = redux::redis_config()
   rush = rsh(network_id = "test_network", config = config_local)
   rush
}
}
