% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midas_functions.R
\name{umemfit}
\alias{umemfit}
\title{Methods for obtaining (and evaluating) a variety of MEM(-MIDAS)-based models}
\usage{
umemfit(
  model,
  skew,
  x,
  daily_ret = NULL,
  mv_m = NULL,
  K = NULL,
  out_of_sample = NULL
)
}
\arguments{
\item{model}{Model to estimate. Valid choices are: "MEMMIDAS" for MEM-MIDAS, "MEM" for base MEM.}

\item{skew}{The skewness parameter linked to lagged daily returns. Valid choices are: "YES" and "NO".}

\item{x}{Dependent variable to predict. Usually the realized volatility. It must be positive and "xts" object.}

\item{daily_ret}{\strong{optional}. Daily returns, which must be an "xts" object. NULL by default.}

\item{mv_m}{\strong{optional}. MIDAS variable already transformed into a matrix, through \code{\link{mv_into_mat}} function. NULL by default.}

\item{K}{\strong{optional}. Number of (lagged) realizations of the MIDAS variable to consider. NULL by default.}

\item{out_of_sample}{\strong{optional}. A positive integer indicating the number of periods before the last to keep for out of sample forecasting.}
}
\value{
\code{umemfit} returns an object of class 'rumidas'. The function \code{\link{summary.rumidas}}
can be used to print a summary of the results. Moreover, an object of class 'rumidas' is a list containing the following components:
\itemize{
\item model: The model used for the estimation.
\item rob_coef_mat: The matrix of estimated coefficients, with the QML standard errors.
For details, see: \insertCite{Bollerslev_Wooldridge_1992;textual}{rumidas}, \insertCite{engle_gallo_2006;textual}{rumidas}, and  \insertCite{amendola2020doubly;textual}{rumidas}.
\item obs: The number of daily observations used for the (in-sample) estimation.
\item period: The period of the in-sample estimation.
\item loglik: The value of the log-likelihood at the maximum.
\item inf_criteria: The AIC and BIC information criteria.
\item loss_in_s: The in-sample MSE and QLIKE averages, calculated considering the distance with respect to the dependent variable.
\item est_in_s: The in-sample predicted dependent variable.
\item est_lr_in_s: The in-sample predicted long-run component (if present) of the dependent variable.
\item loss_oos: The out-of-sample MSE and QLIKE averages, calculated considering the distance with respect to the dependent variable.
\item est_oos: The out-of-sample predicted dependent variable.
\item est_lr_oos: The out-of-sample predicted long-run component (if present) of the dependent variable.
}
}
\description{
Estimates several MEM-MIDAS-based models.
}
\details{
Function \code{umemfit} implements the estimation and evaluation of the MEM and MEM-MIDAS models, with and without the asymmetric term
linked to negative lagged daily returns. The general framework assumes that:
\deqn{x_{i,t}= \mu_{i,t}\epsilon_{i,t} = \tau_{t} \xi_{i,t} \epsilon_{i,t},}
where
\itemize{
\item \eqn{x_{i,t}} is a time series coming from a non-negative discrete time process for the \eqn{i}-th day (\eqn{i = 1, \ldots, N_t})
of the period \eqn{t} (for example, a week, a month or a quarter; \eqn{t = 1 , \ldots, T});
\item \eqn{\tau_{t}} is the long-run component, determining the average level of the conditional mean, varying each period \eqn{t};
\item \eqn{\xi_{i,t}} is a factor centered around one, labelled as the short-run term, which plays the role of dumping or amplifying \eqn{\tau_{i,t}};
\item \eqn{\epsilon_{i,t}} is an \eqn{iid} error term which, conditionally on the information set, has a unit mean, an unknown variance, and a probability density function
defined over a non-negative support.
}
The short-run component of the MEM-MIDAS is:
\deqn{\xi_{i,t}=(1-\alpha-\gamma/2-\beta) + \left(\alpha +  \gamma \cdot {I}_{\left(r_{i-1,t}  < 0 \right)}\right) \frac{x_{i-1,t}}{\tau_t} + \beta \xi_{i-1,t},}
where \eqn{I_{(\cdot)}} is an indicator function and \eqn{r_{i,t}} is the daily return of the day \eqn{i} of the period \eqn{t}.
The long-run component of the MEM-MIDAS is:
\deqn{\tau_{t} = \exp \left\{ m + \theta \sum_{k=1}^K \delta_{k}(\omega) X_{t-k}\right\},}
where \eqn{X_{t}} is the MIDAS term. When the "skew" parameter is set to "NO", \eqn{\gamma} disappears.
The MEM model does not have the difference between the long- and short-run components. Therefore, it directly evolves according to \eqn{\mu_{i,t}}.
When the "skew" parameter is present:
\deqn{\mu_{i,t}= \left(1-\alpha - \gamma_{1} / 2 - \beta   \right)\mu + (\alpha + \gamma I_{\left(r_{i-1,t}  < 0 \right)}) x_{i-1,t} +   \beta \mu_{i-1,t},}
where \eqn{\mu=E(x_{i,t})}. When the "skew" parameter is set to "NO", in the previous equation \eqn{\gamma} cancels.
}
\examples{

# estimate the base MEM, without the asymmetric term linked to negative lagged returns
real<-(rv5['2003/2010'])^0.5		# realized volatility
fit<-umemfit(model="MEM",skew="NO",x=real)
fit
summary.rumidas(fit)
# to see the estimated coefficients with the QML standard errors:
fit$rob_coef_mat

# All the other elements of fit are:
names(fit)

# estimate the MEM-MIDAS, with the asymmetric term linked to negative lagged returns,
# leaving the last 200 observations for the out-of-sample analysis
# r_t<-sp500['2003/2010']
# real<-(rv5['2003/2010'])^0.5		# realized volatility
# mv_m<-mv_into_mat(real,diff(indpro),K=12,"monthly")
# fit_2<-umemfit(model="MEMMIDAS",skew="YES",x=real,daily_ret=r_t,mv_m=mv_m,K=12,out_of_sample=200)
# fit_2
# summary.rumidas(fit_2)
# to see the estimated coefficients with the QML standard errors:
# fit_2$rob_coef_mat

}
\seealso{
\code{\link{mv_into_mat}}.
}
