% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeline.R
\name{get_timeline}
\alias{get_timeline}
\title{get_timeline}
\usage{
get_timeline(user, n = 200, max_id = NULL, parse = TRUE, token = NULL,
  ...)
}
\arguments{
\item{user}{Screen name or user id of target user.}

\item{n}{Numeric, number of tweets to return.}

\item{max_id}{Character, status_id from which returned tweets
should be older than}

\item{parse}{Logical, indicating whether to return parsed
(data.frames) or nested list (fromJSON) object. By default,
\code{parse = TRUE} saves users from the time
[and frustrations] associated with disentangling the Twitter
API return objects.}

\item{token}{OAuth token. By default \code{token = NULL} fetches a
non-exhausted token from an environment variable. Find instructions
on how to create tokens and setup an environment variable in the
tokens vignette (in r, send \code{?tokens} to console).}

\item{\dots}{Futher arguments passed on to \code{make_url}.
All named arguments that do not match the above arguments
(i.e., count, type, etc.) will be built into the request.
To return only English language tweets, for example, use
\code{lang = "en"}. Or, to exclude retweets, use
\code{include_rts = FALSE}. For more options see Twitter's
API documentation.}
}
\value{
List consisting of two data frames. One with the tweets
  data for a specified user and the second is a single row for
  the user provided.
}
\description{
Returns timeline of tweets from a specified
  Twitter user.
}
\examples{
\dontrun{
# get 2000 from Donald Trump's account
djt <- get_timeline("realDonaldTrump", n = 2000)

# data frame where each observation (row) is a different tweet
djt

# users data for realDonaldTrump is also retrieved.
# access it via users_data() users_data(hrc)
users_data(djt)
}
}
\seealso{
\url{https://dev.twitter.com/overview/documentation}

Other tweets: \code{\link{get_favorites}},
  \code{\link{lookup_statuses}},
  \code{\link{search_tweets}}, \code{\link{stream_tweets}},
  \code{\link{tweets_data}}
}

