% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memory_beta.R
\name{mb_image}
\alias{mb_image}
\title{Memory Beta images}
\usage{
mb_image(url, file, keep = FALSE)
}
\arguments{
\item{url}{character, the short URL of the image, for example as returned by
\code{memory_beta()}. Must be JPG or PNG. See example.}

\item{file}{character, output file name. Optional. See details.}

\item{keep}{logical, if \code{FALSE} (default) then \code{file} is only temporary.}
}
\value{
a ggplot object
}
\description{
Download a Memory Beta image and return a ggplot object.
}
\details{
By default the downloaded file is not retained (\code{keep = FALSE}). The filename
is derived from \code{url} if \code{file} is not provided. Whether or not the output
file is kept, a ggplot object of the image is returned.
}
\examples{
\dontrun{mb_image("File:DataBlaze.jpg")}
}
