% Generated by roxygen2 (4.0.1): do not edit by hand
\name{ie_epa}
\alias{ie_epa}
\title{Search itemized EPA enforcement actions.}
\usage{
ie_epa(case_name = NULL, case_num = NULL, defendants = NULL,
  first_date = NULL, last_date = NULL, location_addresses = NULL,
  penalty = NULL, page = NULL, return = "table", per_page = NULL,
  key = getOption("SunlightLabsKey",
  stop("need an API key for Sunlight Labs")), ...)
}
\arguments{
\item{case_name}{(character) The name of the enforcement case.}

\item{case_num}{(character) One or more specific case numbers.}

\item{defendants}{(character) Full-text search for the name(s) of the defendant companies.}

\item{first_date}{(character) Start of a date range of the most recent date of significance to
the case in ISO format.}

\item{last_date}{(character) End of a date range of the most recent date of significance to the
case in ISO format.}

\item{location_addresses}{(character) Full-text search on all addresses associated with the case.}

\item{penalty}{(integer) Total penalties, in US dollars.}

\item{page}{The page of results to return; defaults to 1.}

\item{per_page}{The number of results to return per page, defaults to 1,000.
The maximum number of records per page is 100,000.}

\item{key}{your SunlightLabs API key; loads from .Rprofile}

\item{...}{Optional additional curl options (debugging tools mostly)}

\item{return}{(character) One of table (default), list, or response (httr response object).
When table is requested, the default, a table is not always returned, but is returned almost
always. You can then make a table yourself if you like.}
}
\value{
A list, as class ie_epa.
}
\description{
Search itemized EPA enforcement actions.
}
\examples{
\dontrun{
ie_epa(defendants='Massey Energy', per_page=1)
ie_epa(defendants='Massey Energy', per_page=1, return='list')
ie_epa(defendants='Massey Energy', per_page=1, return='response')
ie_epa(defendants='Massey Energy', first_date='>|2005-01-01')
}
}

