/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.persistence;

import java.text.ParseException;
import org.vikamine.kernel.data.AttributeProvider;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.persistence.SelectorMarshaller;
import org.vikamine.kernel.persistence.SelectorPersistenceManager;
import org.vikamine.kernel.subgroup.selectors.NegatedSGSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class NegatedSelectorMarshaller
implements SelectorMarshaller {
    @Override
    public void marshall(SGSelector selector, Element element, Document document) {
        NegatedSGSelector negSel = (NegatedSGSelector)selector;
        Element child = new SelectorPersistenceManager().marshall(negSel.getPositiveSelector(), document);
        element.appendChild(child);
    }

    @Override
    public SGSelector unmarshall(Element element, AttributeProvider attributeProvider, Ontology ontology) throws ParseException {
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i) instanceof Element) {
                SGSelector positive = new SelectorPersistenceManager().unmarshall((Element)children.item(i), attributeProvider, ontology);
                return new NegatedSGSelector(positive);
            }
            ++i;
        }
        throw new ParseException("Missing child-element for negated-selector", -1);
    }
}

