/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data.discretization;

import java.util.ArrayList;
import java.util.List;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.DataView;
import org.vikamine.kernel.data.NumericAttribute;
import org.vikamine.kernel.data.discretization.AbstractDiscretizationMethod;
import org.vikamine.kernel.data.discretization.DiscretizationUtils;

public class The345RuleDiscretizer
extends AbstractDiscretizationMethod {
    private static final String NAME = "3-4-5 Rule Discretizer";
    private static final String REC_DEPTH = "rec-depth";
    private static final int DEF_RECDEPTH = 1;
    private int recDepth;

    private static int power(double val) {
        int res = (int)Math.floor(Math.log10(Math.abs(val)));
        return res;
    }

    private static double sigDigitBase(double lowVal, double highVal) {
        double res = Math.pow(10.0, Math.max(The345RuleDiscretizer.power(highVal), The345RuleDiscretizer.power(lowVal)));
        return res == 0.0 ? 1.0 : res;
    }

    private static void discretize(double minVal, double maxVal, double fivePercent, double ninetyFivePercent, double sigDigitBase, List<Double> cutPoints, int recursions) {
        if (recursions == 0) {
            cutPoints.add(maxVal);
            return;
        }
        --recursions;
        double lowerBoundaryDigit = Math.floor(fivePercent / sigDigitBase);
        double upperBoundaryDigit = Math.ceil(ninetyFivePercent / sigDigitBase);
        double lowerBoundary = lowerBoundaryDigit * sigDigitBase;
        if (minVal < lowerBoundary) {
            The345RuleDiscretizer.discretize(minVal, lowerBoundary, minVal, lowerBoundary, The345RuleDiscretizer.sigDigitBase(minVal, lowerBoundary), cutPoints, 1);
            minVal = lowerBoundary;
        }
        double upperBoundary = upperBoundaryDigit * sigDigitBase;
        boolean maxValPartition = false;
        double maxValSave = 0.0;
        if (maxVal > upperBoundary) {
            maxValSave = maxVal;
            maxVal = upperBoundary;
            maxValPartition = true;
        }
        sigDigitBase /= 10.0;
        switch ((int)(upperBoundaryDigit - lowerBoundaryDigit)) {
            case 1: 
            case 5: 
            case 10: {
                The345RuleDiscretizer.equalWidthPartition(5, minVal, maxVal, lowerBoundary, upperBoundary, sigDigitBase, cutPoints, recursions);
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                The345RuleDiscretizer.equalWidthPartition(4, minVal, maxVal, lowerBoundary, upperBoundary, sigDigitBase, cutPoints, recursions);
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                The345RuleDiscretizer.equalWidthPartition(3, minVal, maxVal, lowerBoundary, upperBoundary, sigDigitBase, cutPoints, recursions);
                break;
            }
            case 7: {
                The345RuleDiscretizer.twoThreeTwoPartition(minVal, maxVal, lowerBoundary, upperBoundary, sigDigitBase, cutPoints, recursions);
                break;
            }
            case 0: {
                break;
            }
            default: {
                The345RuleDiscretizer.discretize(minVal, maxVal, minVal, maxVal, sigDigitBase * 100.0, cutPoints, recursions + 1);
            }
        }
        if (maxValPartition) {
            The345RuleDiscretizer.discretize(upperBoundary, maxValSave, upperBoundary, maxValSave, The345RuleDiscretizer.sigDigitBase(upperBoundary, maxValSave), cutPoints, 1);
        }
    }

    private static void equalWidthPartition(int count, double minVal, double maxVal, double lowerBoundary, double upperBoundary, double sigDigitBase, List<Double> cutPoints, int recursions) {
        double width = (upperBoundary - lowerBoundary) / (double)count;
        do {
            lowerBoundary = upperBoundary = lowerBoundary + width;
        } while (minVal > upperBoundary);
        The345RuleDiscretizer.discretize(minVal, upperBoundary, minVal, upperBoundary, sigDigitBase, cutPoints, recursions);
        upperBoundary = lowerBoundary + width;
        while (upperBoundary < maxVal) {
            The345RuleDiscretizer.discretize(lowerBoundary, upperBoundary, lowerBoundary, upperBoundary, sigDigitBase, cutPoints, recursions);
            lowerBoundary = upperBoundary;
            upperBoundary = lowerBoundary + width;
        }
        The345RuleDiscretizer.discretize(lowerBoundary, maxVal, lowerBoundary, maxVal, sigDigitBase, cutPoints, recursions);
    }

    private static void twoThreeTwoPartition(double minVal, double maxVal, double lowerBoundary, double upperBoundary, double sigDigitBase, List<Double> cutPoints, int recursions) {
        double width = (upperBoundary - lowerBoundary) / 7.0;
        if (minVal < (upperBoundary = lowerBoundary + 2.0 * width) && upperBoundary < maxVal) {
            The345RuleDiscretizer.discretize(minVal, upperBoundary, minVal, upperBoundary, sigDigitBase, cutPoints, recursions);
            lowerBoundary = upperBoundary;
        } else {
            lowerBoundary = minVal;
        }
        upperBoundary += 3.0 * width;
        if (minVal < upperBoundary && upperBoundary < maxVal) {
            The345RuleDiscretizer.discretize(lowerBoundary, upperBoundary, lowerBoundary, upperBoundary, sigDigitBase, cutPoints, recursions);
            lowerBoundary = upperBoundary;
        }
        The345RuleDiscretizer.discretize(lowerBoundary, maxVal, lowerBoundary, maxVal, sigDigitBase, cutPoints, recursions);
    }

    public The345RuleDiscretizer() {
        this.recDepth = 1;
    }

    public The345RuleDiscretizer(DataView population, NumericAttribute na, int recDepth) {
        this.recDepth = recDepth;
        this.setPopulation(population);
        this.setAttribute(na);
    }

    public The345RuleDiscretizer(String[] args) {
        this();
        int i = 1;
        while (i < args.length) {
            String[] arg = args[i].split("=");
            if (arg[0].contains(REC_DEPTH)) {
                this.recDepth = Integer.parseInt(arg[1].trim());
            }
            ++i;
        }
    }

    private List<Double> discretize(List<DataRecord> sortedRecords) {
        ArrayList<Double> cutPoints = new ArrayList<Double>();
        double minVal = sortedRecords.get(0).getValue(this.attribute);
        cutPoints.add(minVal);
        int fivePercentRecord = sortedRecords.size() / 20;
        int ninetyFiveRecord = fivePercentRecord * 19;
        double fivePercentVal = sortedRecords.get(fivePercentRecord).getValue(this.attribute);
        double ninetyFiveVal = sortedRecords.get(ninetyFiveRecord).getValue(this.attribute);
        The345RuleDiscretizer.discretize(minVal, sortedRecords.get(sortedRecords.size() - 1).getValue(this.attribute), fivePercentVal, ninetyFiveVal, The345RuleDiscretizer.sigDigitBase(fivePercentVal, ninetyFiveVal), cutPoints, this.recDepth);
        return cutPoints;
    }

    @Override
    public List<Double> getCutpoints() {
        if (this.population == null || this.attribute == null || this.population.dataset().getIndex(this.attribute) < 0 || this.population.size() < 2) {
            return new ArrayList<Double>();
        }
        this.sortedSample = DiscretizationUtils.getSortedDataRecords(this.population, this.attribute, false, false);
        List<Double> cutPoints = this.discretize(this.sortedSample);
        return cutPoints;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

