/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import org.vikamine.kernel.data.NominalAttribute;
import org.vikamine.kernel.data.SingleValue;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.util.VKMUtil;

public class StringAttribute
extends NominalAttribute {
    static final String ARFF_ATTRIBUTE_STRING_IDENTIFIER = "string";

    public StringAttribute(String attributeId) {
        super(attributeId);
        this.rawValues = new ArrayList();
        this.valueIndicesHash = new Hashtable();
    }

    public int addStringValue(String value) {
        this.cachedHashCodeIsUpToDate = false;
        Object store = this.toStoredValue(value);
        Integer index = (Integer)this.valueIndicesHash.get(store);
        if (index != null) {
            return index;
        }
        int intIndex = this.rawValues.size();
        this.rawValues.add(store);
        this.valueIndicesHash.put(store, intIndex);
        return intIndex;
    }

    private void addStringValue(StringAttribute src, int index) {
        this.cachedHashCodeIsUpToDate = false;
        Boolean store = src.rawValues.add(index);
        Integer oldIndex = (Integer)this.valueIndicesHash.get(store);
        if (oldIndex != null) {
            return;
        }
        int intIndex = this.rawValues.size();
        this.rawValues.add(store);
        this.valueIndicesHash.put(store, intIndex);
    }

    @Override
    public StringAttribute copy() {
        StringAttribute copiedStringAttribute = new StringAttribute(this.getId());
        int i = 0;
        while (i < this.getRawValuesCount()) {
            copiedStringAttribute.addStringValue(this, i);
            ++i;
        }
        return copiedStringAttribute;
    }

    private void createFreshNominalAttributeValues() {
        if (this.allValues == null || this.allValues.isEmpty()) {
            this.allValues = new LinkedList();
            int i = 0;
            while (i < this.getRawValuesCount()) {
                String id = this.getRawValue(i);
                SingleValue val = SingleValue.createSimpleSingleValue(this, i, id);
                this.allValues.add(val);
                ++i;
            }
        }
    }

    @Override
    public boolean isNominal() {
        return false;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public Iterator<Value> allValuesIterator() {
        this.createFreshNominalAttributeValues();
        return this.allValues.iterator();
    }

    @Override
    public Value getNominalValue(int value) {
        this.createFreshNominalAttributeValues();
        return (Value)this.allValues.get(value);
    }

    @Override
    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append("@attribute").append(" ").append(VKMUtil.quote(this.getId())).append(" ");
        text.append(" STRING");
        return text.toString();
    }
}

