% Generated by roxygen2 (4.0.2): do not edit by hand
\name{without_front.rpqueue}
\alias{without_front.rpqueue}
\title{Return a version of an rpqueue without the front element}
\usage{
\method{without_front}{rpqueue}(x, ...)
}
\arguments{
\item{x}{rpqueue to remove elements from.}

\item{...}{additional arguments to be passed to or from methods (ignored).}
}
\value{
version of the rpqueue with the front element removed.
}
\description{
Simply returns a version of the given rpqueue without the front element. Results in an error if the structure is empty.
The original rpqueue is left alone.
}
\details{
Runs in \eqn{O(1)} worst case time.
}
\examples{
q <- rpqueue()
q <- insert_back(q, "a")
q <- insert_back(q, "b")
q <- insert_back(q, "c")

q2 <- without_front(q)
print(q2)

q3 <- without_front(q)
print(q3)

print(q)
}
\references{
Okasaki, Chris. Purely Functional Data Structures. Cambridge University Press, 1999.
}
\seealso{
\code{\link{peek_front}} for accessing the front element.
}

