% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recommendation_retrieval.R
\name{recommendation_retrieval}
\alias{recommendation_retrieval}
\title{ScienceDirect Article Recommendation Retrieval}
\usage{
recommendation_retrieval(id, identifier = c("eid", "pii"), http_end = NULL,
  ...)
}
\arguments{
\item{id}{Identifier for recommendation}

\item{identifier}{Type of identifier to use}

\item{http_end}{any additional end to http statement.
See \code{\link{generic_elsevier_api}}}

\item{...}{Arguments to be passed to \code{\link{generic_elsevier_api}}}
}
\value{
List of elements, similar to \code{\link{generic_elsevier_api}}
}
\description{
This function wraps \code{\link{generic_elsevier_api}} to give a
retrieval of a recommendation from the Elsevier Article Recommendation API
}
\examples{
api_key = get_api_key(NULL, error = FALSE)
if (!is.null(api_key)){
   x = recommendation_retrieval("S1053811915002700", identifier = "pii",
   verbose = FALSE)
}
}
\seealso{
\code{\link{generic_elsevier_api}}
}
