% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_journal.R
\name{get_journal}
\alias{get_journal}
\title{Scrape meta-data from articles published by a journal hosted on Scielo}
\usage{
get_journal(journal_id, last_issue = TRUE)
}
\arguments{
\item{journal_id}{a character vector with the ID of the journal hosted on Scielo
(the \code{get_ournal_id} function can be used to find the journal ID from its URL).}

\item{last_issue}{a logical vector, if \code{FALSE} scrapes all issues of the journal,
if \code{TRUE} (default) only scrapes its last issue.}
}
\value{
The function returns a \code{tibble} with the following variables:

\itemize{
  \item author: Author name.
  \item first_author_surname: First author surname.
  \item institution: Author's institution.
  \item inst_adress: Author's institution address.
  \item country: Author's country.
  \item title: Article title.
  \item year: Year of publication.
  \item journal: Journal name.
  \item volume: Volume.
  \item number: Number.
  \item first_page: Article's first page.
  \item last_page: Article's last page
  \item abstratc: Article's abstract.
  \item keywords: Article's keywords.
  \item article_id:
  \item doi: DOI.
  \item n_authors: Number of authors.
  \item n_pages: Number of pages.
  \item n_refs: Number of references.
}
}
\description{
\code{get_journal()} scrapes meta-data information from articles of a
 journal hosted on Scielo. In bilingual journals, articles' titles, abstracts
 and other relevant information are retrieved in the journal's main language
 used for publication (most of the time, it is English). The function can extract
 information from all articles ever published by the journal or only the ones
 in its latest issue.
}
\details{
This functions scrapes several meta-data information, such as
author's names, articles' titles, year of publication, edition and number of pages,
 that can be summarized with specific \code{summary} method.
}
\note{
Sometimes, the Scielo website is offline for maintaince,
in which cases this function will not work (i.e., users will get HTML status
different from the usual 200 OK).
}
\examples{
\donttest{
df <- get_journal(journal_id = "1981-3821")
summary(df)
}
}
\seealso{
\code{\link{get_article_meta}}
}
