/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.DBIDInt;
import com.hp.hpl.jena.db.impl.DriverRDB;
import com.hp.hpl.jena.db.impl.Driver_PostgreSQL;
import com.hp.hpl.jena.db.impl.SQLCache;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public class Driver_MsSQL
extends Driver_PostgreSQL {
    protected static final String DEFAULT_SQL = "etc/postgresql.sql";

    public Driver_MsSQL() {
        String myPackageName = this.getClass().getPackage().getName();
        this.DATABASE_TYPE = "MsSQL";
        this.DRIVER_NAME = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        this.ID_SQL_TYPE = "INTEGER";
        this.URI_COMPRESS = false;
        this.INDEX_KEY_LENGTH = 225;
        this.INDEX_KEY_LENGTH_MAX = 225;
        this.LONG_OBJECT_LENGTH = 225;
        this.LONG_OBJECT_LENGTH_MAX = 225;
        this.TABLE_NAME_LENGTH_MAX = 128;
        this.IS_XACT_DB = true;
        this.PRE_ALLOCATE_ID = false;
        this.SKIP_DUPLICATE_CHECK = false;
        this.SQL_FILE = "etc/mssql.sql";
        this.QUOTE_CHAR = (char)39;
        this.DB_NAMES_TO_UPPER = false;
        this.setTableNames(this.TABLE_NAME_PREFIX);
        this.m_psetClassName = myPackageName + ".PSet_TripleStore_RDB";
        this.m_psetReifierClassName = myPackageName + ".PSet_ReifStore_RDB";
        this.m_lsetClassName = myPackageName + ".SpecializedGraph_TripleStore_RDB";
        this.m_lsetReifierClassName = myPackageName + ".SpecializedGraphReifier_RDB";
    }

    public void setConnection(IDBConnection dbcon) {
        this.m_dbcon = dbcon;
        try {
            Properties defaultSQL = SQLCache.loadSQLFile(DEFAULT_SQL, null, this.ID_SQL_TYPE);
            this.m_sql = new SQLCache(this.SQL_FILE, defaultSQL, dbcon, this.ID_SQL_TYPE);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            logger.error("Unable to set connection for Driver:", (Throwable)e);
        }
    }

    private int getSequence(PreparedStatement ps) throws SQLException {
        ps.execute();
        int updateCount = ps.getUpdateCount();
        boolean bMoreResults = true;
        int attempts = 0;
        while (bMoreResults || updateCount != -1) {
            ++attempts;
            ResultSet rs = ps.getResultSet();
            if (rs != null) {
                rs.next();
                int seq = rs.getInt(1);
                rs.close();
                return seq;
            }
            bMoreResults = ps.getMoreResults();
            updateCount = ps.getUpdateCount();
            if (attempts <= 10) continue;
            System.err.println("Loop in getSequence");
            break;
        }
        return -1;
    }

    public DBIDInt addRDBLongObject(DriverRDB.RDBLongObject lobj, String table) throws RDFRDBException {
        Object result = null;
        try {
            int argi = 1;
            String opname = "insertLongObject";
            PreparedStatement ps = this.m_sql.getPreparedSQLStatement(opname, table);
            ps.setString(argi++, lobj.head);
            if (lobj.tail.length() > 0) {
                ps.setLong(argi++, lobj.hash);
                ps.setString(argi++, lobj.tail);
            } else {
                ps.setNull(argi++, -5);
                ps.setNull(argi++, -1);
            }
            int x = this.getSequence(ps);
            return new DBIDInt(x);
        }
        catch (Exception e1) {
            throw new RDFRDBException("Failed to add long object ", e1);
        }
    }

    public int graphIdAlloc(String graphName) {
        Object result = null;
        try {
            PreparedStatement ps = this.m_sql.getPreparedSQLStatement("insertGraph", this.GRAPH_TABLE);
            ps.setString(1, graphName);
            int x = this.getSequence(ps);
            return x;
        }
        catch (SQLException e) {
            throw new RDFRDBException("Failed to get last inserted ID: " + e);
        }
    }

    protected void getTblParams(String[] param) {
        if (this.LONG_OBJECT_LENGTH > 4000) {
            throw new RDFRDBException("Long object length specified (" + this.LONG_OBJECT_LENGTH + ") exceeds maximum sane length of 4000.");
        }
        if (this.INDEX_KEY_LENGTH > 4000) {
            throw new RDFRDBException("Index key length specified (" + this.INDEX_KEY_LENGTH + ") exceeds maximum sane length of 4000.");
        }
        String spoColType = "NVARCHAR(" + this.LONG_OBJECT_LENGTH + ")";
        this.STRINGS_TRIMMED = false;
        param[0] = spoColType;
        String headColType = "NVARCHAR(" + this.INDEX_KEY_LENGTH + ")";
        this.STRINGS_TRIMMED = false;
        param[1] = headColType;
        param[2] = this.TABLE_NAME_PREFIX;
    }
}

