/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.GraphRDB;
import com.hp.hpl.jena.db.impl.DBPattern;
import com.hp.hpl.jena.db.impl.DBQueryStage;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.db.impl.VarDesc;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.ExpressionSet;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.Pipe;
import com.hp.hpl.jena.graph.query.SimpleQueryHandler;
import com.hp.hpl.jena.graph.query.Stage;
import com.hp.hpl.jena.shared.JenaException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBQueryHandler
extends SimpleQueryHandler {
    private GraphRDB graph;
    boolean queryOnlyStmt;
    boolean queryOnlyReif;
    boolean queryFullReif;
    private boolean doFastpath;
    private boolean doImplicitJoin;

    public DBQueryHandler(GraphRDB graph) {
        super(graph);
        this.graph = graph;
        if (graph.reificationBehavior() == 1) {
            this.queryOnlyStmt = false;
            this.queryOnlyReif = false;
            this.queryFullReif = false;
        } else {
            this.queryOnlyReif = false;
            this.queryFullReif = false;
            this.queryOnlyStmt = true;
        }
        this.doFastpath = true;
    }

    public void setDoFastpath(boolean val) {
        this.doFastpath = val;
    }

    public boolean getDoFastpath() {
        return this.doFastpath;
    }

    public void setDoImplicitJoin(boolean val) {
        this.doImplicitJoin = val;
    }

    @Override
    public Stage patternStage(Mapping varMap, ExpressionSet constraints, Triple[] givenTriples) {
        return this.avoidFastpath(constraints, givenTriples) ? super.patternStage(varMap, constraints, givenTriples) : this.patternStageWithFullpath(varMap, constraints, givenTriples);
    }

    private boolean avoidFastpath(ExpressionSet constraints, Triple[] givenTriples) {
        return !this.doFastpath || givenTriples.length == 0 || givenTriples.length == 1 && !constraints.isComplex();
    }

    private Stage patternStageWithFullpath(Mapping varMap, ExpressionSet constraints, Triple[] givenTriples) {
        int i;
        ArrayList<Stage> stages = new ArrayList<Stage>();
        ArrayList<Integer> patternsToDo = new ArrayList<Integer>();
        for (i = 0; i < givenTriples.length; ++i) {
            patternsToDo.add(new Integer(i));
        }
        DBPattern[] source = this.createDBPatterns(varMap, givenTriples);
        while (patternsToDo.size() > 0) {
            DBPattern src = this.findCheapPattern(varMap, patternsToDo, source);
            ArrayList<VarDesc> varList = new ArrayList<VarDesc>();
            ExpressionSet evalCons = new ExpressionSet();
            ArrayList<DBPattern> queryPatterns = new ArrayList<DBPattern>();
            queryPatterns.add(src);
            boolean pushQueryIntoSQL = false;
            if (src.isSingleSource()) {
                VarDesc vx;
                src.addFreeVars(varList);
                boolean didJoin = this.attemptJoiningOthers(patternsToDo, source, src, varList, queryPatterns);
                if (didJoin) {
                    pushQueryIntoSQL = true;
                } else {
                    for (i = 0; i < varList.size(); ++i) {
                        vx = (VarDesc)varList.get(i);
                        if (vx.isArgVar || !this.findConstraints(constraints, evalCons, vx)) continue;
                        pushQueryIntoSQL = true;
                    }
                }
                if (pushQueryIntoSQL) {
                    for (i = 0; i < varList.size(); ++i) {
                        vx = (VarDesc)varList.get(i);
                        if (vx.isArgVar) continue;
                        vx.bindToVarMap(varMap);
                    }
                }
            } else if (!src.hasSource()) {
                pushQueryIntoSQL = true;
            }
            Stage newStage = pushQueryIntoSQL ? new DBQueryStage(this.graph, src.hasSource() ? src.singleSource() : null, varList, queryPatterns, evalCons) : super.patternStage(varMap, constraints, new Triple[]{src.pattern});
            stages.add(newStage);
        }
        return stages.size() == 1 ? (Stage)stages.get(0) : new StageSequence(stages);
    }

    private boolean attemptJoiningOthers(List<Integer> patternsToDo, DBPattern[] source, DBPattern src, List<VarDesc> varList, List<DBPattern> queryPatterns) {
        boolean foundJoin;
        boolean didJoin = false;
        do {
            foundJoin = false;
            for (int i = 0; i < patternsToDo.size(); ++i) {
                DBPattern candidate = source[patternsToDo.get(i)];
                if (!candidate.joinsWith(src, varList, this.queryOnlyStmt, this.queryOnlyReif, this.doImplicitJoin)) continue;
                queryPatterns.add(candidate);
                patternsToDo.remove(i);
                candidate.addFreeVars(varList);
                candidate.setBusy();
                didJoin = true;
                foundJoin = true;
            }
        } while (foundJoin && patternsToDo.size() != 0);
        return didJoin;
    }

    private DBPattern findCheapPattern(Mapping varMap, List<Integer> patternsToDo, DBPattern[] sources) {
        DBPattern cheapSource = null;
        boolean haveConnectedPattern = false;
        int minCost = 100;
        int minConnCost = 100;
        int selectedPatternIndex = -1;
        for (int i = 0; i < patternsToDo.size(); ++i) {
            DBPattern unstaged = sources[patternsToDo.get(i)];
            int cost = unstaged.cost(varMap);
            if (unstaged.isConnected()) {
                if (cost >= minConnCost) continue;
                cheapSource = unstaged;
                minConnCost = cost;
                haveConnectedPattern = true;
                selectedPatternIndex = i;
                continue;
            }
            if (haveConnectedPattern || cost >= minCost) continue;
            minCost = cost;
            cheapSource = unstaged;
            selectedPatternIndex = i;
        }
        if (cheapSource == null) {
            throw new JenaException("impossible: no cheapest pattern among sources");
        }
        cheapSource.setBusy();
        patternsToDo.remove(selectedPatternIndex);
        return cheapSource;
    }

    private DBPattern[] createDBPatterns(Mapping varMap, Triple[] givenTriples) {
        DBPattern[] sources = new DBPattern[givenTriples.length];
        int reifBehavior = this.graph.reificationBehavior();
        for (int i = 0; i < givenTriples.length; ++i) {
            sources[i] = this.createInitialPattern(varMap, reifBehavior, givenTriples[i]);
        }
        return sources;
    }

    private DBPattern createInitialPattern(Mapping varMap, int reifBehavior, Triple triple) {
        DBPattern src = new DBPattern(triple, varMap);
        this.associateWithSources(src, triple, reifBehavior);
        return src;
    }

    private void associateWithSources(DBPattern src, Triple pat, int reifBehavior) {
        Iterator<SpecializedGraph> it = this.graph.getSpecializedGraphs();
        while (it.hasNext()) {
            SpecializedGraph sg = it.next();
            char sub = sg.subsumes(pat, reifBehavior);
            if (sub != 'n') {
                src.sourceAdd(sg, sub);
            }
            if (sub != 'a') continue;
            break;
        }
    }

    public void setQueryOnlyAsserted(boolean opt) {
        if (opt && this.queryOnlyReif) {
            throw new JenaException("QueryOnlyAsserted and QueryOnlyReif cannot both be true");
        }
        this.queryOnlyStmt = opt;
    }

    public boolean getQueryOnlyAsserted() {
        return this.queryOnlyStmt;
    }

    public void setQueryOnlyReified(boolean opt) {
        if (this.graph.reificationBehavior() != 1) {
            throw new JenaException("Reified statements cannot be queried for this model's reification style: " + this.graph.getReifier().getStyle());
        }
        if (opt && this.queryOnlyStmt) {
            throw new JenaException("QueryOnlyAsserted and QueryOnlyReif cannot both be true");
        }
        this.queryOnlyReif = opt;
    }

    public boolean getQueryOnlyReified() {
        return this.queryOnlyReif;
    }

    public void setQueryFullReified(boolean opt) {
        if (this.graph.reificationBehavior() != 1) {
            throw new JenaException("Reified statements cannot be queried for this model's reification style");
        }
        this.queryFullReif = opt;
    }

    public boolean getQueryFullReified() {
        return this.queryFullReif;
    }

    private boolean findConstraints(ExpressionSet constraints, ExpressionSet evalCons, VarDesc vx) {
        boolean res = false;
        Iterator<Expression> it = constraints.iterator();
        while (it.hasNext()) {
            String f;
            Expression l;
            Expression e = it.next();
            if (!e.isApply() || e.argCount() != 2 || !(l = e.getArg(0)).isVariable() || !vx.var.getName().equals(l.getName()) || !this.dbPartiallyHandlesExpression(f = e.getFun())) continue;
            evalCons.add(e);
            res = true;
        }
        return res;
    }

    private boolean dbPartiallyHandlesExpression(String f) {
        return f.equals("urn:x-jena:expr:J_startsWith") || f.equals("urn:x-jena:expr:J_startsWithInsensitive") || f.equals("urn:x-jena:expr:J_contains") || f.equals("urn:x-jena:expr:J_containsInsensitive") || f.equals("urn:x-jena:expr:J_endsWith") || f.equals("urn:x-jena:expr:J_endsWithInsensitive");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class StageSequence
    extends Stage {
        private final int numStages;
        private final Stage[] stages;

        protected StageSequence(List<Stage> stages) {
            this.numStages = stages.size();
            this.stages = stages.toArray(new Stage[this.numStages]);
        }

        @Override
        public Stage connectFrom(Stage s) {
            for (int i = 0; i < this.numStages; ++i) {
                this.stages[i].connectFrom(s);
                s = this.stages[i];
            }
            return super.connectFrom(s);
        }

        @Override
        public Pipe deliver(Pipe L) {
            return this.stages[this.numStages - 1].deliver(L);
        }
    }
}

