/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.out;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Quad;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.CharsetEncoder;
import org.openjena.atlas.io.BufferingWriter;
import org.openjena.atlas.lib.Chars;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.out.OutputLangUtils;
import org.openjena.riot.system.Prologue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinkQuadOutput
implements Sink<Quad> {
    private CharsetEncoder encoder = Chars.charsetUTF8.newEncoder();
    private Prologue prologue = null;
    private BufferingWriter out;
    private Node lastS = null;
    private Node lastP = null;
    private Node lastO = null;
    private Node lastG = null;

    public SinkQuadOutput(OutputStream outs) {
        this(outs, null);
    }

    public SinkQuadOutput(OutputStream outs, Prologue prologue) {
        BufferingWriter.SinkOutputStream dest = new BufferingWriter.SinkOutputStream(outs);
        this.out = new BufferingWriter(dest);
        this.setPrologue(prologue);
    }

    public void setPrologue(Prologue prologue) {
        this.prologue = prologue;
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public void send(Quad quad) {
        Node s = quad.getSubject();
        Node p = quad.getPredicate();
        Node o = quad.getObject();
        Node g = quad.getGraph();
        OutputLangUtils.output((Writer)this.out, s, this.prologue);
        this.out.output(" ");
        OutputLangUtils.output((Writer)this.out, p, this.prologue);
        this.out.output(" ");
        OutputLangUtils.output((Writer)this.out, o, this.prologue);
        if (g != null && g != Quad.tripleInQuad) {
            this.out.output(" ");
            OutputLangUtils.output((Writer)this.out, g, this.prologue);
        }
        this.out.output(" .");
        this.out.output("\n");
    }

    @Override
    public void close() {
        this.flush();
    }
}

