/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.function;

import com.hp.hpl.jena.query.QueryBuildException;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.FunctionBase;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FunctionBase3
extends FunctionBase {
    @Override
    public void checkBuild(String uri, ExprList args) {
        if (args.size() != 3) {
            throw new QueryBuildException("Function '" + Utils.className(this) + "' takes three arguments");
        }
    }

    @Override
    public final NodeValue exec(List<NodeValue> args) {
        if (args == null) {
            throw new ARQInternalErrorException(Utils.className(this) + ": Null args list");
        }
        if (args.size() != 3) {
            throw new ExprEvalException(Utils.className(this) + ": Wrong number of arguments: Wanted 3, got " + args.size());
        }
        NodeValue v1 = args.get(0);
        NodeValue v2 = args.get(1);
        NodeValue v3 = args.get(2);
        return this.exec(v1, v2, v3);
    }

    public abstract NodeValue exec(NodeValue var1, NodeValue var2, NodeValue var3);
}

