/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.out;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.iri.IRIFactory;
import com.hp.hpl.jena.sparql.core.Quad;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import org.openjena.atlas.io.OutputUtils;
import org.openjena.riot.out.NodeFmtLib;
import org.openjena.riot.system.PrefixMap;
import org.openjena.riot.system.Prologue;

public class OutputLangUtils {
    private static boolean asciiOnly = true;
    private static int relFlags = 9;
    static boolean applyUnicodeEscapes = true;

    public static void output(Writer out, Quad quad, Prologue prologue) {
        Node s = quad.getSubject();
        Node p = quad.getPredicate();
        Node o = quad.getObject();
        Node g = quad.getGraph();
        OutputLangUtils.output(out, s, p, o, g, prologue);
    }

    public static void output(Writer out, Node s, Node p, Node o, Node g, Prologue prologue) {
        OutputLangUtils.output(out, s, prologue);
        OutputLangUtils.print(out, " ");
        OutputLangUtils.output(out, p, prologue);
        OutputLangUtils.print(out, " ");
        OutputLangUtils.output(out, o, prologue);
        if (g != null) {
            OutputLangUtils.print(out, " ");
            OutputLangUtils.output(out, g, prologue);
        }
        OutputLangUtils.print(out, " .");
        OutputLangUtils.println(out);
    }

    public static void output(Writer out, Triple triple, Node graphNode, Prologue prologue) {
        Node s = triple.getSubject();
        Node p = triple.getPredicate();
        Node o = triple.getObject();
        OutputLangUtils.output(out, s, p, o, graphNode, prologue);
    }

    public static void output(Writer out, Triple triple, Prologue prologue) {
        Node s = triple.getSubject();
        Node p = triple.getPredicate();
        Node o = triple.getObject();
        OutputLangUtils.output(out, s, p, o, null, prologue);
    }

    public static void output(Writer out, Node node, Prologue prologue) {
        if (node.isURI()) {
            OutputLangUtils.printIRI(out, node.getURI(), prologue);
            return;
        }
        if (node.isBlank()) {
            OutputLangUtils.print(out, "_:");
            String label = node.getBlankNodeLabel();
            label = NodeFmtLib.safeBNodeLabel(label);
            OutputLangUtils.print(out, label);
            return;
        }
        if (node.isLiteral()) {
            OutputLangUtils.print(out, '\"');
            OutputLangUtils.outputEsc(out, node.getLiteralLexicalForm());
            OutputLangUtils.print(out, '\"');
            if (node.getLiteralLanguage() != null && node.getLiteralLanguage().length() > 0) {
                OutputLangUtils.print(out, '@');
                OutputLangUtils.print(out, node.getLiteralLanguage());
            }
            if (node.getLiteralDatatypeURI() != null) {
                OutputLangUtils.print(out, "^^");
                OutputLangUtils.printIRI(out, node.getLiteralDatatypeURI(), prologue);
            }
            return;
        }
        if (node.isVariable()) {
            OutputLangUtils.print(out, '?');
            OutputLangUtils.print(out, node.getName());
            return;
        }
        System.err.println("Illegal node: " + node);
    }

    private static void printIRI(Writer out, String iriStr, Prologue prologue) {
        if (prologue != null) {
            String x;
            String pname;
            PrefixMap pmap = prologue.getPrefixMap();
            if (pmap != null && (pname = OutputLangUtils.prefixFor(iriStr, pmap)) != null) {
                OutputLangUtils.print(out, pname);
                return;
            }
            String base = prologue.getBaseURI();
            if (base != null && (x = OutputLangUtils.abbrevByBase(iriStr, base)) != null) {
                iriStr = x;
            }
        }
        OutputLangUtils.print(out, "<");
        if (asciiOnly) {
            OutputLangUtils.outputEsc(out, iriStr);
        } else {
            OutputLangUtils.print(out, iriStr);
        }
        OutputLangUtils.print(out, ">");
    }

    private static String prefixFor(String uri, PrefixMap mapping) {
        if (mapping == null) {
            return null;
        }
        String pname = mapping.abbreviate(uri);
        if (pname != null) {
            return pname;
        }
        return null;
    }

    public static String abbrevByBase(String uri, String base) {
        if (base == null) {
            return null;
        }
        IRI baseIRI = IRIFactory.jenaImplementation().construct(base);
        IRI rel = baseIRI.relativize(uri, relFlags);
        String r = null;
        try {
            r = rel.toASCIIString();
        }
        catch (MalformedURLException ex) {
            r = rel.toString();
        }
        return r;
    }

    private static void print(Writer out, String s) {
        try {
            out.append(s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void print(Writer out, char ch) {
        try {
            out.append(ch);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void println(Writer out) {
        try {
            out.append("\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void outputEsc(Writer out, String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '\"') {
                OutputLangUtils.print(out, '\\');
                OutputLangUtils.print(out, c);
                continue;
            }
            if (c == '\n') {
                OutputLangUtils.print(out, "\\n");
                continue;
            }
            if (c == '\t') {
                OutputLangUtils.print(out, "\\t");
                continue;
            }
            if (c == '\r') {
                OutputLangUtils.print(out, "\\r");
                continue;
            }
            if (c == '\f') {
                OutputLangUtils.print(out, "\\f");
                continue;
            }
            if (c >= ' ' && c < '\u007f') {
                OutputLangUtils.print(out, c);
                continue;
            }
            if (!asciiOnly) {
                OutputLangUtils.print(out, c);
                continue;
            }
            OutputLangUtils.print(out, "\\u");
            OutputUtils.printHex(out, (int)c, 4);
        }
    }
}

