% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtx-utils.R
\name{orthmax2}
\alias{orthmax2}
\title{Orthomax Rotation}
\usage{
orthmax2(A1, A2, gamma1, gamma2, conv = 1e-06)
}
\arguments{
\item{A1}{A numeric matrix.}

\item{A2}{A numeric matrix, with the same number of columns as \code{A1}}

\item{gamma1}{orthmax parameter for A1}

\item{gamma2}{orthmax parameter for A1}

\item{conv}{Convergence criterion (default is \code{conv=1e-6})}
}
\value{
A list with the following elements will be returned:

   \itemize{
   \item \code{B1} rotated version of \code{A1}
   \item \code{B2} rotated version of \code{A2}
   \item \code{T} rotation matrix
   \item \code{f} orthomax function value
   }
}
\description{
Performs simultaneous orthomax rotation of two matrices
 (using one rotation matrix).
}
\details{
The function to be maximized is
 \code{sum((A1^2) - 1/nrow(A1) * gamma1 * sum((sum(A1^2))^2))^2 + sum((A2^2) - 1/nrow(A2) * gamma2 * sum((sum(A2^2))^2))^2}.
}
