% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsummary.R
\name{rsummary_node}
\alias{rsummary_node}
\title{Create an rsumary relop operator node.}
\usage{
rsummary_node(
  source,
  ...,
  quartiles = FALSE,
  tmp_name_source = wrapr::mk_tmp_name_source("sn"),
  temporary = TRUE
)
}
\arguments{
\item{source}{incoming source (relop node or data.frame).}

\item{...}{force later arguments to be by name}

\item{quartiles}{logical, if TRUE add Q1 (25\%), median (50\%), Q3 (75\%) quartiles.}

\item{tmp_name_source}{wrapr::mk_tmp_name_source(), temporary name generator.}

\item{temporary}{logical, if TRUE use temporary tables}
}
\value{
rsummary node
}
\description{
This is a non_sql_node, so please see \code{\link{non_sql_node}} for some of the issues for this node type.
}
\examples{

if (requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  d <- data.frame(p= c(TRUE, FALSE, NA),
                  s= NA,
                  w= 1:3,
                  x= c(NA,2,3),
                  y= factor(c(3,5,NA)),
                  z= c('a',NA,'a'),
                  stringsAsFactors=FALSE)
  db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  RSQLite::initExtension(db)
  rq_copy_to(db, "dRemote", d,
              overwrite = TRUE,
              temporary = TRUE)

  ops <- db_td(db, "dRemote") \%.>\%
    extend(., v \%:=\% ifelse(x>2, "x", "y")) \%.>\%
    rsummary_node(.)
  cat(format(ops))

  print(to_sql(ops, db))

  reshdl <- materialize(db, ops)
  print(DBI::dbGetQuery(db, to_sql(reshdl, db)))

  DBI::dbDisconnect(db)
}

}
\seealso{
\code{\link{quantile_node}}, \code{\link{non_sql_node}}
}
