% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order_by.R
\name{order_rows}
\alias{order_rows}
\title{Make an orderby node (not a relational operation).}
\usage{
order_rows(
  source,
  cols = NULL,
  ...,
  reverse = NULL,
  limit = NULL,
  env = parent.frame()
)
}
\arguments{
\item{source}{source to select from.}

\item{cols}{order by column names.}

\item{...}{force later arguments to be bound by name}

\item{reverse}{character, which columns to reverse ordering of.}

\item{limit}{number limit row count.}

\item{env}{environment to look to.}
}
\value{
order_by node.
}
\description{
Order a table by a set of columns (not general expressions) and
limit number of rows in that order.
}
\details{
Note: this is a relational operator in that it takes a table that
is a relation (has unique rows) to a table that is still a relation.
However, most relational systems do not preserve row order in storage or between
operations.  So without the limit set this is not a useful operator except
as a last step prior to pulling data to an in-memory \code{data.frame} (
which does preserve row order).
}
\examples{

if (requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  d <- rq_copy_to(my_db, 'd',
                   data.frame(AUC = 0.6, R2 = 0.2))
  optree <- order_rows(d, cols = "AUC", reverse = "AUC", limit=4)
  cat(format(optree))
  sql <- to_sql(optree, my_db)
  cat(sql)
  print(DBI::dbGetQuery(my_db, sql))
  DBI::dbDisconnect(my_db)
}

}
