% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ex_data_frame.R
\name{apply_right.relop}
\alias{apply_right.relop}
\title{Execute pipeline treating pipe_left_arg as local data to
be copied into database.}
\usage{
\method{apply_right}{relop}(pipe_left_arg, pipe_right_arg,
  pipe_environment, left_arg_name, pipe_string, right_arg_name)
}
\arguments{
\item{pipe_left_arg}{left argument.}

\item{pipe_right_arg}{pipe_right_arg argument.}

\item{pipe_environment}{environment to evaluate in.}

\item{left_arg_name}{name, if not NULL name of left argument.}

\item{pipe_string}{character, name of pipe operator.}

\item{right_arg_name}{name, if not NULL name of right argument.}
}
\value{
data.frame
}
\description{
Execute pipeline treating pipe_left_arg as local data to
be copied into database.
}
\examples{

# WARNING: example tries to change rquery.rquery_db_executor option to RSQLite and back.
if (requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  # set up example database and
  # db execution helper
  db <- DBI::dbConnect(RSQLite::SQLite(),
                       ":memory:")
  RSQLite::initExtension(db)
  old_o <- options(list("rquery.rquery_db_executor" = list(db = db)))

  # operations pipeline/tree
  optree <- mk_td("d", "x") \%.>\%
    extend(., y = x*x)

  # wrapr dot pipe apply_right dispatch
  # causes this statment to apply optree
  # to d.
  data.frame(x = 1:3) \%.>\% optree \%.>\% print(.)

  # remote example
  rq_copy_to(db, "d",
              data.frame(x = 7:8),
              overwrite = TRUE,
              temporary = TRUE)

  # wrapr dot pipe apply_right dispatch
  # causes this statment to apply optree
  # to db.
  db \%.>\% optree \%.>\% print(.)

  # clean up
  options(old_o)
  DBI::dbDisconnect(db)
}

}
\seealso{
\code{\link{rquery_apply_to_data_frame}}
}
