% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qtree_18_02_02.R
\name{qtree}
\alias{qtree}
\alias{rpms::qtree}
\title{qtree}
\usage{
qtree(t1, title = "rpms", label = NA, caption = "", digits = 2,
  scale = 1, lscape = FALSE)
}
\arguments{
\item{t1}{rpms object created by rpms function}

\item{title}{string for the top node of the tree}

\item{label}{string used for labeling the tree figure}

\item{caption}{string used for caption}

\item{digits}{integer number of displayed digits}

\item{scale}{numeric factor for scaling size of tree}

\item{lscape}{boolean to display tree in landscape mode}
}
\description{
Code to write a latex qtree plot
takes a rpm frame and returns latex code to produce qtree
uses linearize as a guide
Produces text code to produce tree structure in tex document
Requires using LaTex packages and the following commands in preamble of 
LaTex doc: 
usepackage\{lscape\}
usepackage\{tikz-qtree\}
}
\examples{
{
# model mean of retirement account value for households with reported 
# retirment account values > 0 using a binary tree while accounting for 
# clusterd data and sample weights.

s1<- which(CE$IRAX > 0)
r1 <-rpms(IRAX~EDUCA+AGE+BLS_URBN, data = CE[s1,],  weights=~FINLWT21, clusters=~CID) 

# get Latex code
qtree(r1)

}
}
