% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpm.R
\name{rpm}
\alias{rpm}
\alias{rpm.object}
\title{Fit a Revealed Preference Matchings Model}
\usage{
rpm(
  formula,
  Xdata,
  Zdata,
  Xid = NULL,
  Zid = NULL,
  pair_id = NULL,
  X_w = NULL,
  Z_w = NULL,
  pair_w = NULL,
  sampled = NULL,
  sampling_design = "stock-flow",
  control = control.rpm(),
  verbose = FALSE
)
}
\arguments{
\item{formula}{formula; an \code{\link{formula}} object, of the form \code{
~ <model terms>}. For the details on the possible \code{<model terms>}, see
\code{\link{rpm-terms}}.}

\item{Xdata}{data.frame for women. Each row is a woman, each column is a variable on that women
or her partnerships. It must contain the women's ID variable (see \code{Xid}) and
a variable with the ID of the women's partner. If the women is single the men's ID should be NA.}

\item{Zdata}{data.frame for men. Each row is a man, each column is a variable on that men
It must contain the men's ID variable (see \code{Zid}).}

\item{Xid}{string The name of the variable in \code{Xdata} containing the IDs of the women.}

\item{Zid}{string The name of the variable in \code{Zdata} containing the IDs of the men.}

\item{pair_id}{string The name of the variable in \code{Xdata} containing the ID of the men paired with the women in
\code{Xid}. If the women is not paired it must be NA.}

\item{X_w}{string The name of the variable in \code{Xdata} containing the individual weight of the women.
If this is NULL then it is assumed the sample is unweighted from a population with 2000 women in it.}

\item{Z_w}{string The name of the variable in \code{Zdata} containing the individual weight of the man
If this is NULL then it is assumed the sample is unweighted from a population with 2000 men in it.}

\item{pair_w}{string The name of the variable in \code{Xdata} containing the pair weight of that women.
If the women is not paired it should be NA.
If this is NULL then it is computed from the individual weights using the \code{sampling_design}.
Note that the pair weights currently do not play a role in the estimation. They do in the quasi-likelihood version of the code.
If this is NULL then it is assumed the sample is unweighted from a population with 2000 men in it.}

\item{sampled}{string The name of the logical variable in \code{Xdata} and \code{Zdata} containing the 
indicator that the person was sampled directly (as distinct from being included as the match of a directly sampled
person. All single people are directly sampled.}

\item{sampling_design}{string; The name of the sampling protocol used to select the survey data. Valid values are
\code{"stock-flow"} (default) (individuals are sampled, data contains both
singles and couples);
\code{"stock-stock"} (households are sampled, each household can be a single or a couple);
\code{"census"} (the sample is a census of the population of people).}

\item{control}{A list of control parameters for algorithm tuning. Constructed using
\code{\link{control.rpm}}, which should be consulted for specifics.}

\item{verbose}{logical; if this is \code{TRUE}, the program will print out
additional information, including data summary statistics.}
}
\value{
\code{\link{rpm}} returns an object of class \code{\link{rpm.object}}
that is a list consisting of the following elements: 
\item{coef}{The maximum psuedo-likelihood estimate of \eqn{\theta}, the vector of
coefficients for the model parameters. This includes the model \eqn{\beta} and the model \eqn{\Gamma}.}
\item{coefficients}{The bias-corrected bootstrap estimate of \eqn{\theta}, the vector of
coefficients for the model parameters. This includes the model \eqn{\beta} and the model \eqn{\Gamma}.}
\item{loglik}{The value of the maximized log-likelihood.}
\item{exitflag}{integer value with the status of the optimization (4 is success as 
\code{xtol_rel} or \code{xtol_abs} was reached). Other codes are 1 = generic success; 2 = optimization stopped because 
\code{ftol_rel} or \code{ftol_abs} was reached; 3 = optimization stopped 
because \code{stopval} was reached; 4 = optimization stopped because \code{xtol_rel} or \code{xtol_abs} was reached; 
5 = optimization stopped because
\code{maxeval} was reached; 6 = optimization stopped because \code{maxtime} was reached.}
\item{call}{the call that was made to \code{nloptr}.}
\item{x0}{vector with starting values for the optimization.}
\item{message}{more informative message with the status of the optimization.}
\item{iterations}{number of iterations that were executed.}
\item{objective}{value if the objective function in the solution.}
\item{solution}{optimal value of the controls.}
\item{version}{version of NLopt that was used.}
\item{covar}{Approximate covariance matrix of the estimates.}
\item{eq}{Values from the equality constraints. Larger values indicate non-convergence.}
\item{sample}{A matrix with the number of rows the MCMC sample size and the number of rows the number of parameters.}
}
\description{
\code{\link{rpm}} estimates the parameters of a revealed preference model
for men and women of certain
characteristics (or shared characteristics) of people of the opposite sex.
The model assumes a one-to-one stable matching using an observed set of
matchings and a set of (possibly dyadic) covariates to 
estimate the parameters for
linear equations of utilities.
It does this using an large-population likelihood based on ideas from Dagsvik (2000), Menzel (2015) and Goyal et al (2023).
}
\details{
The pairings are determined by the \code{pair_id} variable in \code{Xdata}. 
If that variable is NA then the women is
assumed to be single. If men are listed in \code{Zdata} and are not partnered then they are assumed single.
Weights are specified by three optional variables in \code{Xdata}.
\itemize{
\item{X_w}{This is character string of the name of the weight variable for women. The sum of the weights should be the
number of women in the population.}
\item{Z_w}{This is character string of the name of the weight variable for men. The sum of the weights should be the
number of men in the population.}
\item{pair_w}{This is character string of the name of the weight variable for pairs.}
}
}
\examples{
library(rpm)
data(fauxmatching)
\donttest{
fit <- rpm(~match("edu") + WtoM_diff("edu",3),
          Xdata=fauxmatching$Xdata, Zdata=fauxmatching$Zdata,
          X_w="X_w", Z_w="Z_w",
          pair_w="pair_w", pair_id="pair_id", Xid="pid", Zid="pid",
          sampled="sampled",sampling_design="stock-flow")
summary(fit)
}
}
\references{
Goyal, Shuchi; Handcock, Mark S.; Jackson, Heide M.; Rendall, Michael S. and Yeung, Fiona C. (2023).
\emph{A Practical Revealed Preference Model for Separating Preferences and Availability Effects in Marriage Formation}
\emph{Journal of the Royal Statistical Society}, A. \doi{10.1093/jrsssa/qnad031} 
Dagsvik, John K. (2000) \emph{Aggregation in Matching Markets} \emph{International Economic Review}, Vol. 41, 27-57.
JSTOR: https://www.jstor.org/stable/2648822, \doi{10.1111/1468-2354.00054}
Menzel, Konrad (2015).
\emph{Large Matching Markets as Two-Sided Demand Systems}
Econometrica, Vol. 83, No. 3 (May, 2015), 897-941. \doi{10.3982/ECTA12299}
}
\seealso{
control.rpm, summary.rpm, print.rpm
}
\keyword{models}
