% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{pdo}
\alias{pdo}
\alias{rpdo}
\title{Pacific Decadal Oscillation Index}
\format{A tbl data frame:
\describe{
  \item{Year}{The year as an integer.}
  \item{Month}{The month as an integer.}
  \item{PDO}{The Pacific Decadal Oscillation index as a numeric.}
}}
\usage{
pdo
}
\description{
Monthly Pacific Decadal Oscillation (PDO) index
values from January 1900 to present.
}
\details{
For more information see \code{vignette("rpdo")}.
}
\examples{
library(rpdo)
library(ggplot2)

data(pdo)
ggplot(data = subset(pdo, pdo$Month == 1), aes(x = Year, y = PDO)) +
 geom_line() + ylab("January PDO Index")
}
\seealso{
\url{http://research.jisao.washington.edu/pdo/PDO.latest}
}
\keyword{datasets}

