% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoother2.r
\name{kernel}
\alias{kernel}
\title{Perform Kernel Regression on Time Series Data}
\usage{
kernel(input, bandwidth = "auto")
}
\arguments{
\item{input}{Vector of Time Series Data}

\item{bandwidth}{\describe{
\item{numerical}{ Choice of Bandwith}
\item{\code{'auto'}}{ Choose bandwith automatically by Cross Validation for the given sample}
}}
}
\value{
Vector containing smoothed time series data, prints the bandwidth used.
}
\description{
Perform kernel regression in line with Lo et al. (2000). Either specify a bandwidth or let it be determined
automatically.
}
\details{
For an overview of the package capabilities, click here \link{rpatrec}.
}
\examples{
\dontrun{
#create a standard HS pattern:
a <- generator()
#add noise to this patterns
b <- noise(a,'white',10)
#smooth to regain the signal
c <- kernel(b,2)
}


}
