% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/taxonomy.R
\name{taxonomy_taxon}
\alias{ott_taxon_name.taxon_info}
\alias{synonyms.taxon_info}
\alias{tax_rank.taxon_info}
\alias{taxonomy_taxon}
\title{Taxon information}
\usage{
taxonomy_taxon(ott_ids, ...)

\method{tax_rank}{taxon_info}(tax)

\method{ott_taxon_name}{taxon_info}(tax)

\method{synonyms}{taxon_info}(tax, ...)
}
\arguments{
\item{ott_ids}{the ott ids of the taxon of interest (numeric or
character containing only numbers)}

\item{...}{additional arguments to customize the API request (see
\code{\link{rotl}} package documentation).}

\item{tax}{an object generated by the \code{taxonomy_taxon}
function}
}
\value{
\code{taxonomy_taxon} returns a list detailing information
    about the taxa. \code{tax_rank} and \code{ott_taxon_name}
    return a vector. \code{synonyms} returns a list whose elements
    are the synonyms for each of the \code{ott_id} requested.
}
\description{
Information about taxa.
}
\details{
Given a vector of ott ids, \code{taxonomy_taxon} returns
information about the specified taxa.

The functions \code{tax_rank}, \code{ott_taxon_name}, and
\code{synonyms} can extract this information from an object
created by the \code{taxonomy_taxon} function.
}
\examples{
\dontrun{
req <- taxonomy_taxon(ott_id=515698)
tax_rank(req)
ott_taxon_name(req)
synonyms(req)
}
}
\seealso{
\code{\link{tnrs_match_names}} to obtain \code{ott_id}
    from a taxonomic name.
}

