% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flat_table_join.R
\name{join_lookup_table}
\alias{join_lookup_table}
\alias{join_lookup_table.flat_table}
\title{Join a flat table with a lookup table}
\usage{
join_lookup_table(ft, fk_attributes, lookup)

\method{join_lookup_table}{flat_table}(ft, fk_attributes = NULL, lookup)
}
\arguments{
\item{ft}{A \code{flat_table} object.}

\item{fk_attributes}{A vector of strings, attribute names.}

\item{lookup}{A \code{flat_table} object.}
}
\value{
A \code{flat_table} object.
}
\description{
To join a flat table with a lookup table, the attributes of the first table
that will be used in the operation are indicated. The lookup table must have
the primary key previously defined.
}
\details{
If no attributes are indicated, those that form the primary key of the lookup
table are considered in the flat table.
}
\examples{

lookup <- flat_table('iris', iris) |>
  lookup_table(
    measures = c("Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width"),
    measure_agg = c('MAX', 'MIN', 'SUM', 'MEAN')
  )
ft <- flat_table('iris', iris) |>
  join_lookup_table(lookup = lookup)

}
\seealso{
\code{\link{flat_table}}

Other flat table join functions: 
\code{\link{check_lookup_table}()},
\code{\link{get_pk_attribute_names}()},
\code{\link{lookup_table}()}
}
\concept{flat table join functions}
