% Generated by roxygen2 (4.0.1): do not edit by hand
\name{getFocal}
\alias{getFocal}
\alias{getFocal.default}
\alias{getFocal.factor}
\title{Select focal values from an observed variable.}
\usage{
getFocal(x, ...)

\method{getFocal}{default}(x, xvals = NULL, n = 3, ...)

\method{getFocal}{factor}(x, xvals = NULL, n = 3, ...)
}
\arguments{
\item{x}{Required. A variable}

\item{...}{Other arguments that will be passed to the
user-specified xvals function.}

\item{xvals}{A function name (either "quantile", "std.dev.",
"table", or "seq") or a user-supplied function that can receive
x and return a selection of values.}

\item{n}{Number of values to be selected.}
}
\value{
A vector.

A named vector of values.
}
\description{
This is a generic function with 2 methods, getFocal.default
handles numeric variables, while getFocal.factor handles
factors. No other methods have been planned for preparation.

Many plotting functions need to select "focal" values from
a variable. There is a family of functions that are used
to do that.  User requests can be accepted in a number
of ways. Numeric and character variables will be treated
differently. Please see details.
}
\details{
This is used in functions like \code{plotSlopes} or
\code{plotCurves}.

If \code{xvals} is not provided, a default divider for numeric
variables will be the algorithm "quantile". The divider algorithms
provided with rockchalk are c("quantile", "std.dev.", "table",
"seq").  \code{xvals} can also be the name of a user-supplied
function, such as R's \code{pretty()}. If the user supplies a
vector of possible values, that selection will be checked to make
sure all elements are within a slightly expanded range of
\code{x}. If a value out of range is requested, a warning is
issued. Maybe that should be an outright error?

With factor variables, \code{xvals} is generally not used because
the only implemented divider algorithm is "table" (see
\code{cutByTable}), which selects the \code{n} most frequently
observed values. That is the default algorithm. It is legal to
specify xvals = "table", but there is no point in doing
that. However, xvals may take two other formats. It may be a
user-specified function that can select levels values from
\code{x} or it may be a vector of labels (or, names of
levels). The purpose of the latter is to check that the requested
levels are actually present in the supplied data vector
\code{x}. If the levels specified are not in the observed
variable, then this function stops with an error message.
}
\examples{
x <- rnorm(100)
getFocal(x)
getFocal(x, xvals = "quantile")
getFocal(x, xvals = "quantile", n = 5)
getFocal(x, xvals = "std.dev")
getFocal(x, xvals = "std.dev", n = 5)
getFocal(x, xvals = c(-1000, 0.2, 0,5))
x <- factor(c("A","B","A","B","C","D","D","D"))
getFocal(x)
getFocal(x, n = 2)
}
\author{
Paul E. Johnson <pauljohn@ku.edu>
}

