% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnoaa-package.r
\docType{package}
\name{rnoaa-package}
\alias{rnoaa-package}
\alias{rnoaa}
\title{rnoaa}
\description{
rnoaa is an R interface to NOAA climate data.
}
\section{Data Sources}{

Many functions in this package interact with the National Climatic Data
Center application programming interface (API) at
https://www.ncdc.noaa.gov/cdo-web/webservices/v2, all of
which functions start with \code{ncdc_}. An access token, or API key, is
required to use all the \code{ncdc_} functions. The key is required by NOAA,
not us. Go to the link given above to get an API key.

More NOAA data sources are being added through time. Data sources and their
function prefixes are:

\itemize{
 \item \code{buoy_*} - NOAA Buoy data from the National Buoy Data Center
 \item \code{gefs_*} - GEFS forecast ensemble data
 \item \code{ghcnd_*} - GHCND daily data from NOAA
 \item \code{isd_*} - ISD/ISH data from NOAA
 \item \code{homr_*} - Historical Observing Metadata Repository (HOMR)
 vignette
 \item \code{ncdc_*} - NOAA National Climatic Data Center (NCDC) vignette
 (examples)
 \item \code{seaice} - Sea ice vignette
 \item \code{storm_} - Storms (IBTrACS) vignette
 \item \code{swdi} - Severe Weather Data Inventory (SWDI) vignette
 \item \code{tornadoes} - From the NOAA Storm Prediction Center
 \item \code{argo_*} - Argo buoys
 \item \code{coops_search} - NOAA CO-OPS - tides and currents data
 \item \code{cpc_prcp} - rainfall data from the NOAA Climate
 Prediction Center (CPC)
 \item \code{arc2} - rainfall data from Africa Rainfall Climatology
 version 2
}
}

\section{A note about NCDF data}{


Functions to work with buoy data use netcdf files. You'll need the
\code{ncdf4} package for those functions, and those only. \code{ncdf4} is
in Suggests in this package, meaning you only need \code{ncdf4} if you are
using the buoy functions. You'll get an informative error telling you to
install \code{ncdf4} if you don't have it and you try to use the
buoy functions.
}

\section{The \code{meteo} family of functions}{


The \code{meteo} family of functions are prefixed with \code{meteo_} and
provide a set of helper functions to:

\itemize{
  \item Identify candidate stations from a latitude/longitude pair
  \item Retrieve complete data for one or more stations
  (\code{meteo_coverage()})
}
}

\keyword{package}
