% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmw_prepare_data.R
\name{rmw_prepare_data}
\alias{rmw_prepare_data}
\title{Function to prepare a data frame for modelling with \strong{rmweather}.}
\usage{
rmw_prepare_data(
  df,
  value = "value",
  na.rm = FALSE,
  replace = FALSE,
  fraction = 0.8
)
}
\arguments{
\item{df}{Input data frame. Generally a time series of air quality data with
pollutant concentrations and meteorological variables.}

\item{value}{Name of the dependent variable. Usually a pollutant, for example,
\code{"no2"} or \code{"pm10"}.}

\item{na.rm}{Should missing values (\code{NA}) be removed from \code{value}?}

\item{replace}{When adding the date variables to the set, should they replace
the versions already contained in the data frame if they exist?}

\item{fraction}{Fraction of the observations to make up the training set. 
Default is 0.8, 80 \%.}
}
\value{
Tibble, the input data transformed ready for modelling with 
\strong{rmweather}.
}
\description{
\code{rmw_prepare_data} will test and prepare a data frame for further use 
with \strong{rmweather}.
}
\details{
\code{rmw_prepare_data} will check if a \code{date} variable is present and 
is of the correct data type, impute missing numeric and categorical values, 
randomly split the input into training and testing sets, and rename the 
dependent variable to \code{"value"}. The \code{date} variable will also be 
used to calculate new variables such as \code{date_unix}, \code{day_julian}, 
\code{weekday}, and \code{hour} which can be used as independent variables. 
These attributes are needed for other \strong{rmweather} functions to operate. 

Use \code{set.seed} in an R session to keep results reproducible.
}
\examples{

# Load package
library(dplyr)

# Keep things reproducible
set.seed(123)

# Prepare example data for modelling, only use no2 data here
data_london_prepared <- data_london \%>\% 
  filter(variable == "no2") \%>\% 
  rmw_prepare_data()

}
\seealso{
\code{\link{set.seed}}, \code{\link{rmw_train_model}}, 
\code{\link{rmw_normalise}}
}
\author{
Stuart K. Grange
}
