/*
 * Decompiled with CFR 0.152.
 */
package com.chenlb.mmseg4j;

import com.chenlb.mmseg4j.Chunk;
import com.chenlb.mmseg4j.Seg;
import com.chenlb.mmseg4j.Sentence;
import com.chenlb.mmseg4j.Word;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.LinkedList;
import java.util.Queue;

public class MMSeg {
    private PushbackReader reader;
    private Seg seg;
    private StringBuilder bufSentence = new StringBuilder(256);
    private Sentence currentSentence;
    private Queue<Word> bufWord;
    private int readedIdx = 0;

    public MMSeg(Reader reader, Seg seg) {
        this.seg = seg;
        this.reset(reader);
    }

    public void reset(Reader reader) {
        this.reader = new PushbackReader(new BufferedReader(reader), 20);
        this.currentSentence = null;
        this.bufWord = new LinkedList<Word>();
        this.bufSentence.setLength(0);
        this.readedIdx = -1;
    }

    private int readNext() throws IOException {
        int n = this.reader.read();
        if (n > -1) {
            ++this.readedIdx;
            n = Character.toLowerCase(n);
        }
        return n;
    }

    private void pushBack(int n) throws IOException {
        --this.readedIdx;
        this.reader.unread(n);
    }

    public Word next() throws IOException {
        Word word = this.bufWord.poll();
        if (word == null) {
            this.bufSentence.setLength(0);
            int n = -1;
            boolean bl = true;
            block12: while (bl && (n = this.readNext()) != -1) {
                bl = false;
                int n2 = Character.getType(n);
                String string = "word";
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        n = MMSeg.toAscii(n);
                        NationLetter nationLetter = this.getNation(n);
                        if (nationLetter == NationLetter.UNKNOW) {
                            bl = true;
                            continue block12;
                        }
                        string = "letter";
                        this.bufSentence.appendCodePoint(n);
                        switch (nationLetter) {
                            case EN: {
                                ReadCharByAsciiOrDigit readCharByAsciiOrDigit = new ReadCharByAsciiOrDigit();
                                this.readChars(this.bufSentence, readCharByAsciiOrDigit);
                                if (!readCharByAsciiOrDigit.hasDigit()) break;
                                string = "letter_or_digit";
                                break;
                            }
                            case RA: {
                                this.readChars(this.bufSentence, new ReadCharByRussia());
                                break;
                            }
                            case GE: {
                                this.readChars(this.bufSentence, new ReadCharByGreece());
                            }
                        }
                        this.bufWord.add(this.createWord(this.bufSentence, string));
                        this.bufSentence.setLength(0);
                        continue block12;
                    }
                    case 5: {
                        this.bufSentence.appendCodePoint(n);
                        this.readChars(this.bufSentence, new ReadCharByType(5));
                        this.currentSentence = this.createSentence(this.bufSentence);
                        this.bufSentence.setLength(0);
                        continue block12;
                    }
                    case 9: {
                        this.bufSentence.appendCodePoint(MMSeg.toAscii(n));
                        this.readChars(this.bufSentence, new ReadCharDigit());
                        string = "digit";
                        int n3 = this.readNext();
                        if (n3 > -1) {
                            if (this.seg.isUnit(n3)) {
                                this.bufWord.add(this.createWord(this.bufSentence, this.startIdx(this.bufSentence) - 1, "digit"));
                                this.bufSentence.setLength(0);
                                this.bufSentence.appendCodePoint(n3);
                                string = "word";
                            } else {
                                this.pushBack(n3);
                                if (this.readChars(this.bufSentence, new ReadCharByAsciiOrDigit()) > 0) {
                                    string = "digit_or_letter";
                                }
                            }
                        }
                        this.bufWord.add(this.createWord(this.bufSentence, string));
                        this.bufSentence.setLength(0);
                        continue block12;
                    }
                    case 10: {
                        this.bufSentence.appendCodePoint(n);
                        this.readChars(this.bufSentence, new ReadCharByType(10));
                        int n4 = this.startIdx(this.bufSentence);
                        for (int i = 0; i < this.bufSentence.length(); ++i) {
                            this.bufWord.add(new Word(new char[]{this.bufSentence.charAt(i)}, n4++, "letter_number"));
                        }
                        this.bufSentence.setLength(0);
                        continue block12;
                    }
                    case 11: {
                        this.bufSentence.appendCodePoint(n);
                        this.readChars(this.bufSentence, new ReadCharByType(11));
                        this.bufWord.add(this.createWord(this.bufSentence, "other_number"));
                        this.bufSentence.setLength(0);
                        continue block12;
                    }
                }
                bl = true;
            }
            if (this.currentSentence != null) {
                do {
                    Chunk chunk = this.seg.seg(this.currentSentence);
                    for (int i = 0; i < chunk.getCount(); ++i) {
                        this.bufWord.add(chunk.getWords()[i]);
                    }
                } while (!this.currentSentence.isFinish());
                this.currentSentence = null;
            }
            word = this.bufWord.poll();
        }
        return word;
    }

    private int readChars(StringBuilder stringBuilder, ReadChar readChar) throws IOException {
        int n = 0;
        int n2 = -1;
        while ((n2 = this.readNext()) != -1) {
            int n3 = readChar.transform(n2);
            if (readChar.isRead(n3)) {
                stringBuilder.appendCodePoint(n3);
                ++n;
                continue;
            }
            this.pushBack(n2);
            break;
        }
        return n;
    }

    private Word createWord(StringBuilder stringBuilder, String string) {
        return new Word(MMSeg.toChars(stringBuilder), this.startIdx(stringBuilder), string);
    }

    private Word createWord(StringBuilder stringBuilder, int n, String string) {
        return new Word(MMSeg.toChars(stringBuilder), n, string);
    }

    private Sentence createSentence(StringBuilder stringBuilder) {
        return new Sentence(MMSeg.toChars(stringBuilder), this.startIdx(stringBuilder));
    }

    private int startIdx(StringBuilder stringBuilder) {
        return this.readedIdx - stringBuilder.length() + 1;
    }

    private static char[] toChars(StringBuilder stringBuilder) {
        char[] cArray = new char[stringBuilder.length()];
        stringBuilder.getChars(0, stringBuilder.length(), cArray, 0);
        return cArray;
    }

    private static int toAscii(int n) {
        if (n >= 65296 && n <= 65305 || n >= 65313 && n <= 65338 || n >= 65345 && n <= 65370) {
            n -= 65248;
        }
        return n;
    }

    private static boolean isAsciiLetter(int n) {
        return n >= 65 && n <= 90 || n >= 97 && n <= 122;
    }

    private static boolean isRussiaLetter(int n) {
        return n >= 1040 && n <= 1103 || n == 1025 || n == 1105;
    }

    private static boolean isGreeceLetter(int n) {
        return n >= 913 && n <= 937 || n >= 945 && n <= 969;
    }

    private NationLetter getNation(int n) {
        if (MMSeg.isAsciiLetter(n)) {
            return NationLetter.EN;
        }
        if (MMSeg.isRussiaLetter(n)) {
            return NationLetter.RA;
        }
        if (MMSeg.isGreeceLetter(n)) {
            return NationLetter.GE;
        }
        return NationLetter.UNKNOW;
    }

    private static boolean isCJK(int n) {
        return n == 5;
    }

    private static boolean isDigit(int n) {
        return n == 9;
    }

    private static boolean isLetter(int n) {
        return n <= 4 && n >= 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NationLetter {
        EN,
        RA,
        GE,
        UNKNOW;

    }

    private static class ReadCharByType
    extends ReadChar {
        int charType;

        public ReadCharByType(int n) {
            this.charType = n;
        }

        boolean isRead(int n) {
            int n2 = Character.getType(n);
            return n2 == this.charType;
        }
    }

    private static class ReadCharByGreece
    extends ReadCharDigit {
        private ReadCharByGreece() {
        }

        boolean isRead(int n) {
            return MMSeg.isGreeceLetter(n);
        }
    }

    private static class ReadCharByRussia
    extends ReadCharDigit {
        private ReadCharByRussia() {
        }

        boolean isRead(int n) {
            return MMSeg.isRussiaLetter(n);
        }
    }

    private static class ReadCharByAscii
    extends ReadCharDigit {
        private ReadCharByAscii() {
        }

        boolean isRead(int n) {
            return MMSeg.isAsciiLetter(n);
        }
    }

    private static class ReadCharByAsciiOrDigit
    extends ReadCharDigit {
        private boolean hasDigit = false;

        private ReadCharByAsciiOrDigit() {
        }

        boolean isRead(int n) {
            boolean bl = super.isRead(n);
            this.hasDigit |= bl;
            return MMSeg.isAsciiLetter(n) || bl;
        }

        boolean hasDigit() {
            return this.hasDigit;
        }
    }

    private static class ReadCharDigit
    extends ReadChar {
        private ReadCharDigit() {
        }

        boolean isRead(int n) {
            int n2 = Character.getType(n);
            return MMSeg.isDigit(n2);
        }

        int transform(int n) {
            return MMSeg.toAscii(n);
        }
    }

    private static abstract class ReadChar {
        private ReadChar() {
        }

        abstract boolean isRead(int var1);

        int transform(int n) {
            return n;
        }
    }
}

