% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Expression.R
\name{Call}
\alias{Call}
\title{Call}
\description{
Create function calls in MiniZinc
}
\examples{
newCall = Call$new(fnName = "sum", args = list(Int$new(2), Int$new(5)))
newCall$c_str()
}
\section{Super class}{
\code{\link[rminizinc:Expression]{rminizinc::Expression}} -> \code{Call}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{.id}}{the function id}

\item{\code{.lExp}}{list of expressions}

\item{\code{.delete_flag}}{used to delete items}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{.id}}{the function id}

\item{\code{.lExp}}{list of expressions}

\item{\code{.delete_flag}}{used to delete items}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Call$new()}}
\item \href{#method-getName}{\code{Call$getName()}}
\item \href{#method-setName}{\code{Call$setName()}}
\item \href{#method-nargs}{\code{Call$nargs()}}
\item \href{#method-getArgs}{\code{Call$getArgs()}}
\item \href{#method-setArgs}{\code{Call$setArgs()}}
\item \href{#method-getArg}{\code{Call$getArg()}}
\item \href{#method-setArg}{\code{Call$setArg()}}
\item \href{#method-c_str}{\code{Call$c_str()}}
\item \href{#method-getDeleteFlag}{\code{Call$getDeleteFlag()}}
\item \href{#method-delete}{\code{Call$delete()}}
\item \href{#method-clone}{\code{Call$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Call$new(fnName, args)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fnName}}{function name}

\item{\code{args}}{the list of expressions}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getName"></a>}}
\if{latex}{\out{\hypertarget{method-getName}{}}}
\subsection{Method \code{getName()}}{
get the function id/string
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Call$getName()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setName"></a>}}
\if{latex}{\out{\hypertarget{method-setName}{}}}
\subsection{Method \code{setName()}}{
get the function id/string
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Call$setName(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{new function name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-nargs"></a>}}
\if{latex}{\out{\hypertarget{method-nargs}{}}}
\subsection{Method \code{nargs()}}{
get the number of arguments
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Call$nargs()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getArgs"></a>}}
\if{latex}{\out{\hypertarget{method-getArgs}{}}}
\subsection{Method \code{getArgs()}}{
get the expression list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Call$getArgs()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setArgs"></a>}}
\if{latex}{\out{\hypertarget{method-setArgs}{}}}
\subsection{Method \code{setArgs()}}{
set the expression list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Call$setArgs(args)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{args}}{list of expressions to be set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getArg"></a>}}
\if{latex}{\out{\hypertarget{method-getArg}{}}}
\subsection{Method \code{getArg()}}{
get the expression based on index
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Call$getArg(i)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{index}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setArg"></a>}}
\if{latex}{\out{\hypertarget{method-setArg}{}}}
\subsection{Method \code{setArg()}}{
set argument i
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Call$setArg(e, i)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{e}}{expression}

\item{\code{i}}{index}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-c_str"></a>}}
\if{latex}{\out{\hypertarget{method-c_str}{}}}
\subsection{Method \code{c_str()}}{
return the MiniZinc representation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Call$c_str()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getDeleteFlag"></a>}}
\if{latex}{\out{\hypertarget{method-getDeleteFlag}{}}}
\subsection{Method \code{getDeleteFlag()}}{
delete flag for internal use
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Call$getDeleteFlag()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delete"></a>}}
\if{latex}{\out{\hypertarget{method-delete}{}}}
\subsection{Method \code{delete()}}{
delete the assignment item
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Call$delete()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Call$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
